# BEGIN SourceDeps(oneline):
BuildRequires: gcc-c++ pkgconfig(audiofile)
# END SourceDeps(oneline)
%{?optflags_lto:%global optflags_lto %optflags_lto -ffat-lto-objects}
# see https://bugzilla.altlinux.org/show_bug.cgi?id=10382
%define _localstatedir %{_var}
# %%name is ahead of its definition. Predefining for rpm 4.0 compatibility.
%define name gig
%define major	12
%define akaimajor 0
%define tarballname libgig
%define libname lib%{name}%{major}
%define libakai lib%{name}-akai%{akaimajor}
%define devname lib%{name}-devel
%define devakai lib%{name}-akai-devel

Name:		gig
Version:	4.5.0
Release:	alt1_1
Summary:	C++ library for loading Gigasampler files and DLS Level 1/2 files
License:	GPLv2 and LGPL
# Note akai library is LGPL
Group:		Sound
Source0:	https://download.linuxsampler.org/packages/libgig-%{version}.tar.bz2
URL:		https://www.linuxsampler.org/libgig/

BuildRequires:	pkgconfig(sndfile)
BuildRequires:	pkgconfig(uuid)
BuildRequires:	doxygen
Requires:	%{libname} = %{version}-%{release}
Source44: import.info

%description
C++ library for accessing Gigasampler/GigaStudio, DLS,
SoundFont and KORG sound files.

%package -n %{libname}
Summary:	C++ library for loading Gigasampler files and DLS Level 1/2 files
Group:		System/Libraries
Requires:	%{name} >= %{version}-%{release}
Provides:	lib%{name} = %{version}-%{release}

%description -n %{libname}
C++ library for loading Gigasampler files and DLS Level 1/2 files.

%package -n %{devname}
Summary:	Header files for developers
Group:		System/Libraries
Requires:	%{libname} = %{version}-%{release}
Provides:	%{name}-devel = %{version}-%{release}
Provides:	%{tarballname}-devel = %{version}-%{release}

%description -n %{devname}
Header files for developers.

%package -n     %{devname}-static
Summary:        Static library for the %{name} library
Group:          Development/C
Requires:       %{devname} = %EVR

%description -n %{devname}-static
This package contains the static %{name} library

%files -n %{devname}-static
%{_libdir}/*.a


%package -n %{libakai}
Summary:	C++ library for accessing AKAI disk images
Group:		System/Libraries
License:	LGPL

%description -n %{libakai}
Akai lib

%package -n %{devakai}
Summary:	Header files for developers
Group:		System/Libraries
License:	LGPL
Requires:	%{libakai} = %{version}-%{release}
Provides:	%{name}-akai-devel = %{version}-%{release}

%description -n %{devakai}
Header files for developers.

%package -n     %{devakai}-static
Summary:        Static library for the %{name} library
Group:          Development/C
Requires:       %{devakai} = %EVR

%description -n %{devakai}-static
This package contains the static %{name} library

%files -n %{devakai}-static
%{_libdir}/*.a


%prep
%setup -q -n lib%{name}-%{version}


%build
%configure
%make_build
make docs

%install
%makeinstall_std
find %{buildroot} -name "*.la" -delete

mv %{buildroot}/%{_libdir}/libgig/* %{buildroot}/%{_libdir}/
rm -rf %{buildroot}/%{_libdir}/libgig

%files
%doc AUTHORS COPYING ChangeLog NEWS README TODO doc/html
%{_mandir}/man1/*
%{_bindir}/*

%files  -n %{libname}
%{_libdir}/libgig.so.%{major}
%{_libdir}/libgig.so.%{major}.*

%files  -n %{devname}
%{_includedir}/*
%{_libdir}/libgig.so
%{_libdir}/pkgconfig/gig.pc

%files -n %{libakai}
%{_libdir}/libakai.so.%{akaimajor}
%{_libdir}/libakai.so.%{akaimajor}.*

%files  -n %{devakai}
%{_libdir}/libakai.so
%{_libdir}/pkgconfig/akai.pc


%changelog
