# BEGIN SourceDeps(oneline):
BuildRequires: pkgconfig(vte-2.90)
# END SourceDeps(oneline)
# see https://bugzilla.altlinux.org/show_bug.cgi?id=10382
%define _localstatedir %{_var}
# %%name and %%version is ahead of its definition. Predefining for rpm 4.0 compatibility.
%define name giggle
%define version 0.7
%define major 0
%define libname lib%{name}%{major}
%define develname lib%{name}-devel

%define url_ver	%(echo %{version} | cut -d. -f1,2)

Summary:	Gtk frontend for git
Name:		giggle
Version:	0.7
Release:	alt2_12
License:	GPLv2+
Group:		Development/Other
URL:		https://wiki.gnome.org/giggle
Source0:	https://download.gnome.org/sources/%{name}/%{url_ver}/%{name}-%{version}.tar.xz
Patch0:		giggle-0.7-gtksourceview-3.8.patch
Patch1:		giggle-0.7-gettext-usage.patch
Patch2:		giggle-0.7-vte2.91.patch
Patch3:		giggle-0.7-fix-build-with-gcc-10.patch
BuildRequires:	pkgconfig(gdk-3.0) >= 3.3.12
BuildRequires:	pkgconfig(gdk-pixbuf-2.0) >= 2.22
BuildRequires:	pkgconfig(gio-2.0) >= 2.30
BuildRequires:	pkgconfig(glib-2.0) >= 2.30
BuildRequires:	pkgconfig(gthread-2.0) >= 2.30
BuildRequires:	pkgconfig(gtk+-3.0) >= 3.3.12
BuildRequires:	pkgconfig(gtksourceview-3.0) >= 3.8
BuildRequires:	pkgconfig(libebook-1.2) >= 3.2
BuildRequires:	pkgconfig(vte-2.91)
BuildRequires:	intltool >= 0.40.0
BuildRequires:	git-core git-cvs
BuildRequires:	itstool
BuildRequires:	yelp-tools
BuildRequires:	xml-utils
BuildRequires:	xsltproc
BuildRequires:	gnome-common
Requires:	git-core git-cvs
Source44: import.info

%description
Giggle is a graphical frontend for the git directory tracker.

%package -n %{libname}
Summary:	%{summary}
Group:		System/Libraries

%description -n %{libname}
Giggle is a graphical frontend for the git directory tracker.

%package -n %{develname}
Summary:	%{summary}
Group:		Development/C
Provides:	lib%{name}-devel = %{version}-%{release}
Provides:	%{name}-devel = %{version}-%{release}
Requires:	%{libname} = %{version}-%{release}

%description -n %{develname}
Giggle is a graphical frontend for the git directory tracker.

%prep
%setup -q
%patch0 -p1
%patch1 -p1
%patch2 -p1
%patch3 -p1


%build
NOCONFIGURE=yes gnome-autogen.sh
%configure --disable-static
%make_build

%install
%makeinstall_std

%find_lang %{name} --with-gnome

find %{buildroot} -name '*.la' -delete

%files -f %{name}.lang
%doc AUTHORS README NEWS ChangeLog
%{_bindir}/*
%dir %{_libdir}/%{name}
%dir %{_libdir}/%{name}/plugins
%dir %{_libdir}/%{name}/plugins/%{version}
%{_libdir}/%{name}/plugins/%{version}/libpersonal-details*
%{_libdir}/%{name}/plugins/%{version}/libterminal-view*
%{_libdir}/%{name}/plugins/%{version}/*.xml
%{_datadir}/%{name}/
%{_datadir}/applications/%{name}.desktop
%{_iconsdir}/hicolor/*/apps/*

%files -n %{libname}
%{_libdir}/libgiggle.so.%{major}*
%{_libdir}/libgiggle-git.so.%{major}*

%files -n %develname
%{_libdir}/libgiggle.so
%{_libdir}/libgiggle-git.so
%{_includedir}/%{name}/


%changelog
