Group: System/Libraries
# BEGIN SourceDeps(oneline):
BuildRequires(pre): rpm-build-perl rpm-macros-fedora-compat
BuildRequires: perl-podlators
# END SourceDeps(oneline)
%add_findreq_skiplist /usr/share/globus/config.guess
# see https://bugzilla.altlinux.org/show_bug.cgi?id=10382
%define _localstatedir %{_var}
Name:		globus-common
%global _name %(tr - _ <<< %{name})
Version:	18.14
Release:	alt1_4
Summary:	Grid Community Toolkit - Common Library

License:	Apache-2.0
URL:		https://github.com/gridcf/gct/
Source:		https://repo.gridcf.org/gct6/sources/%{_name}-%{version}.tar.gz
Source8:	README

BuildRequires:	gcc
BuildRequires:	libltdl7-devel
BuildRequires:	doxygen
BuildRequires:	rpm-build-perl
BuildRequires:	perl-devel

#		Obsolete dropped packages from GCT
Obsoletes:	globus-usage < 6
Source44: import.info

%package progs
Group: Networking/WWW
Summary:	Grid Community Toolkit - Common Library Programs
Requires:	%{name} = %{version}-%{release}

%package devel
Group: Development/C
Summary:	Grid Community Toolkit - Common Library Development Files
Requires:	%{name} = %{version}-%{release}
#		Obsolete dropped packages from GCT
Obsoletes:	globus-usage-devel < 6

%package doc
Group: Documentation
Summary:	Grid Community Toolkit - Common Library Documentation Files
BuildArch:	noarch

%description
The Grid Community Toolkit (GCT) is an open source software toolkit used for
building grid systems and applications. It is a fork of the Globus Toolkit
originally created by the Globus Alliance. It is supported by the Grid
Community Forum (GridCF) that provides community-based support for core
software packages in grid computing.

The %{name} package contains:
Common Library

%description progs
The Grid Community Toolkit (GCT) is an open source software toolkit used for
building grid systems and applications. It is a fork of the Globus Toolkit
originally created by the Globus Alliance. It is supported by the Grid
Community Forum (GridCF) that provides community-based support for core
software packages in grid computing.

The %{name}-progs package contains:
Common Library Programs

%description devel
The Grid Community Toolkit (GCT) is an open source software toolkit used for
building grid systems and applications. It is a fork of the Globus Toolkit
originally created by the Globus Alliance. It is supported by the Grid
Community Forum (GridCF) that provides community-based support for core
software packages in grid computing.

The %{name}-devel package contains:
Common Library Development Files

%description doc
The Grid Community Toolkit (GCT) is an open source software toolkit used for
building grid systems and applications. It is a fork of the Globus Toolkit
originally created by the Globus Alliance. It is supported by the Grid
Community Forum (GridCF) that provides community-based support for core
software packages in grid computing.

The %{name}-doc package contains:
Common Library Documentation Files

%prep
%setup -q -n %{_name}-%{version}

%build
# Reduce overlinking
export LDFLAGS="-Wl,--as-needed -Wl,-z,defs %{?__global_ldflags}"

export GLOBUS_VERSION=6.2
export SH=/bin/sh
%configure --disable-static \
	   --includedir=%{_includedir}/globus \
	   --libexecdir=%{_datadir}/globus \
	   --docdir=%{_docdir}/%{name} \
	   --with-perlmoduledir=%{perl_vendor_privlib} \
	   --with-backward-compatibility-hack

# Reduce overlinking
sed 's!CC \(.*-shared\) !CC \\\${wl}--as-needed \1 !' -i libtool

%make_build

%install
%makeinstall_std

# Remove libtool archives (.la files)
rm %{buildroot}%{_libdir}/*.la

# Install README file
install -m 644 -p %{SOURCE8} %{buildroot}%{_docdir}/%{name}/README

# Remove license file from pkgdocdir
rm %{buildroot}%{_docdir}/%{name}/GLOBUS_LICENSE

# Remove environment scripts
rm %{buildroot}%{_datadir}/globus-user-env.csh
rm %{buildroot}%{_datadir}/globus-user-env.sh
# man page points to non-existent file
pushd %buildroot/usr/share/man/man3/
rm -f globus_module_deactivate.3* globus_hashtable_voidp_keyeq.3* globus_hashtable_to_list.3* globus_hashtable_string_keyeq.3* globus_hashtable_int_keyeq.3*
popd


%check
%make_build check NO_EXTERNAL_NET=1



%files
%{_libdir}/libglobus_common.so.*
%{_libdir}/libglobus_memory_debug.so.*
# This is a loadable module (plugin)
%{_libdir}/libglobus_thread_pthread.so
%dir %{perl_vendor_privlib}/Globus
%dir %{perl_vendor_privlib}/Globus/Core
%{perl_vendor_privlib}/Globus/Core/Config.pm
%{perl_vendor_privlib}/Globus/Core/Paths.pm
%dir %{_docdir}/%{name}
%doc %{_docdir}/%{name}/README
%doc --no-dereference GLOBUS_LICENSE

%files progs
%{_bindir}/globus-domainname
%{_bindir}/globus-hostname
%{_bindir}/globus-sh-exec
%{_bindir}/globus-version
%{_sbindir}/globus-libc-hostname
%{_sbindir}/globus-redia
%dir %{_datadir}/globus
%{_datadir}/globus/config.guess
%{_datadir}/globus/globus-args-parser-header
%{_datadir}/globus/globus-script-initializer*
%{_datadir}/globus/globus-sh-tools.sh
%{_datadir}/globus/globus-sh-tools-vars.sh
%doc %{_mandir}/man1/globus-domainname.1*
%doc %{_mandir}/man1/globus-hostname.1*
%doc %{_mandir}/man1/globus-sh-exec.1*
%doc %{_mandir}/man1/globus-version.1*

%files devel
%dir %{_includedir}/globus
%{_includedir}/globus/*
%{_libdir}/libglobus_common.so
%{_libdir}/libglobus_memory_debug.so
%{_libdir}/pkgconfig/%{name}.pc
%{_bindir}/globus-makefile-header

%files doc
%doc %{_mandir}/man3/*
%dir %{_docdir}/%{name}
%dir %{_docdir}/%{name}/html
%doc %{_docdir}/%{name}/html/*
%doc --no-dereference GLOBUS_LICENSE

%changelog
