Group: Networking/WWW
# BEGIN SourceDeps(oneline):
BuildRequires(pre): rpm-macros-fedora-compat
BuildRequires: libproj-devel
# END SourceDeps(oneline)
BuildRequires: globus-gsi-sysconfig-devel
%define fedora 38
# see https://bugzilla.altlinux.org/show_bug.cgi?id=10382
%define _localstatedir %{_var}
%global _hardened_build 1

%if %{?fedora}%{!?fedora:0} >= 25 || %{?rhel}%{!?rhel:0} >= 8
%global use_systemd 1
%else
%global use_systemd 0
%endif

Name:		globus-gatekeeper
%global _name %(tr - _ <<< %{name})
Version:	11.4
Release:	alt1_9
Summary:	Grid Community Toolkit - Globus Gatekeeper

License:	Apache-2.0
URL:		https://github.com/gridcf/gct/
Source:		https://repo.gridcf.org/gct6/sources/%{_name}-%{version}.tar.gz
Source1:	%{name}.service
Source2:	%{name}
Source3:	%{name}.README
Source8:	README

BuildRequires:	gcc
BuildRequires:	globus-common-devel >= 15
BuildRequires:	globus-gss-assist-devel >= 8
BuildRequires:	globus-gssapi-gsi-devel >= 9
BuildRequires:	libssl-devel
%if %{use_systemd}
BuildRequires:	libsystemd-devel libudev-devel systemd systemd-analyze systemd-homed systemd-networkd
%endif

Requires:	logrotate

%if %{use_systemd}
%{?systemd_requires}
%else
%endif
Source44: import.info

%description
The Grid Community Toolkit (GCT) is an open source software toolkit used for
building grid systems and applications. It is a fork of the Globus Toolkit
originally created by the Globus Alliance. It is supported by the Grid
Community Forum (GridCF) that provides community-based support for core
software packages in grid computing.

The %{name} package contains:
Globus Gatekeeper

%prep
%setup -q -n %{_name}-%{version}

%build
# Reduce overlinking
export LDFLAGS="-Wl,--as-needed -Wl,-z,defs %{?__global_ldflags}"

%configure --disable-static \
	   --includedir=%{_includedir}/globus \
	   --libexecdir=%{_datadir}/globus \
	   --docdir=%{_docdir}/%{name} \
	   --with-initscript-config-path=%{_sysconfdir}/sysconfig/%{name} \
	   --with-lockfile-path=/run/lock/subsys/%{name}

# Reduce overlinking
sed 's!CC \(.*-shared\) !CC \\\${wl}--as-needed \1 !' -i libtool

%make_build

%install
%makeinstall_std

# Remove start-up script
rm -rf %{buildroot}%{_sysconfdir}/init.d

# Install start-up script
%if %{use_systemd}
mkdir -p %{buildroot}%{_unitdir}
install -m 644 -p %{SOURCE1} %{buildroot}%{_unitdir}
%else
mkdir -p %{buildroot}%{_initddir}
install -p %{SOURCE2} %{buildroot}%{_initddir}
%endif

# Install post installation instructions
install -m 644 -p %{SOURCE3} %{buildroot}%{_docdir}/%{name}/README.Fedora

# Install README file
install -m 644 -p %{SOURCE8} %{buildroot}%{_docdir}/%{name}/README

# Remove license file from pkgdocdir
rm %{buildroot}%{_docdir}/%{name}/GLOBUS_LICENSE

mkdir -p %{buildroot}%{_sysconfdir}/grid-services
mkdir -p %{buildroot}%{_sysconfdir}/grid-services/available

%if %{use_systemd}

%pre
/sbin/chkconfig --del %{name} > /dev/null 2>&1 || :

%post
%post_service %{name}

%preun
%preun_service %{name}

%else
%post
if [ $1 -eq 1 ]; then
    /sbin/chkconfig --add %{name}
fi

%preun
if [ $1 -eq 0 ]; then
    /sbin/service %{name} stop > /dev/null 2>&1 || :
    /sbin/chkconfig --del %{name}
fi

%postun
if [ $1 -ge 1 ]; then
    /sbin/service %{name} condrestart > /dev/null 2>&1 || :
fi

%endif

%files
%{_sbindir}/globus-gatekeeper
%{_sbindir}/globus-k5
%if %{use_systemd}
%{_unitdir}/%{name}.service
%else
%{_initddir}/%{name}
%endif
%config(noreplace) %{_sysconfdir}/sysconfig/%{name}
%config(noreplace) %{_sysconfdir}/logrotate.d/%{name}
%dir %{_sysconfdir}/grid-services
%dir %{_sysconfdir}/grid-services/available
%doc %{_mandir}/man8/globus-gatekeeper.8*
%doc %{_mandir}/man8/globus-k5.8*
%dir %{_docdir}/%{name}
%doc %{_docdir}/%{name}/README
%doc %{_docdir}/%{name}/README.Fedora
%doc --no-dereference GLOBUS_LICENSE

%changelog
