Group: Networking/WWW
BuildRequires: perl(DBI.pm) 
%add_findreq_skiplist /usr/sbin/globus-gram-audit

# see https://bugzilla.altlinux.org/show_bug.cgi?id=10382
%define _localstatedir %{_var}
Name:		globus-gram-audit
%global _name %(tr - _ <<< %{name})
Version:	5.1
Release:	alt1_10
Summary:	Grid Community Toolkit - GRAM Jobmanager Auditing

License:	Apache-2.0
URL:		https://github.com/gridcf/gct/
Source:		https://repo.gridcf.org/gct6/sources/%{_name}-%{version}.tar.gz
Source8:	README
BuildArch:	noarch

BuildRequires:	rpm-build-perl

Requires:	crontabs
Requires:	perl(DBD/SQLite.pm)

Requires(post):	perl(DBD/SQLite.pm)
Requires(post):	perl(Globus/Core/Paths.pm)
Source44: import.info

%description
The Grid Community Toolkit (GCT) is an open source software toolkit used for
building grid systems and applications. It is a fork of the Globus Toolkit
originally created by the Globus Alliance. It is supported by the Grid
Community Forum (GridCF) that provides community-based support for core
software packages in grid computing.

The %{name} package contains:
GRAM Jobmanager Auditing

%prep
%setup -q -n %{_name}-%{version}

%build
%configure --disable-static \
	   --includedir=%{_includedir}/globus \
	   --libexecdir=%{_datadir}/globus \
	   --docdir=%{_docdir}/%{name}

%make_build

%install
%makeinstall_std

# Rename cron script
mv %{buildroot}%{_sysconfdir}/cron.hourly/globus-gram-audit.cron \
   %{buildroot}%{_sysconfdir}/cron.hourly/globus-gram-audit

# Install README file
install -m 644 -p %{SOURCE8} %{buildroot}%{_docdir}/%{name}/README

# Remove license file from pkgdocdir
rm %{buildroot}%{_docdir}/%{name}/GLOBUS_LICENSE

%post
if [ $1 -eq 1 ]; then
    globus-gram-audit --query 'select 1 from gram_audit_table' 2> /dev/null || \
    globus-gram-audit --create --quiet || :
fi

%files
%{_sbindir}/globus-gram-audit
%dir %{_datadir}/globus
%dir %{_datadir}/globus/gram-audit
%{_datadir}/globus/gram-audit/*.sql
%dir %{_localstatedir}/lib/globus
%dir %{_localstatedir}/lib/globus/gram-audit
%config(noreplace) %{_sysconfdir}/cron.hourly/globus-gram-audit
%dir %{_sysconfdir}/globus
%config(noreplace) %{_sysconfdir}/globus/gram-audit.conf
%doc %{_mandir}/man8/globus-gram-audit.8*
%dir %{_docdir}/%{name}
%doc %{_docdir}/%{name}/README
%doc --no-dereference GLOBUS_LICENSE

%changelog
