Group: Networking/WWW
# BEGIN SourceDeps(oneline):
BuildRequires(pre): rpm-build-perl
BuildRequires: perl(Globus/Core/Config.pm) perl(Globus/Core/Paths.pm) perl(Globus/GRAM/Error.pm) perl(Globus/GRAM/JobManager.pm) perl(Globus/GRAM/JobState.pm) perl(Globus/GRAM/StdioMerger.pm) perl-podlators
# END SourceDeps(oneline)
%add_findreq_skiplist %{perl_vendor_privlib}/Globus/GRAM/JobManager/*.pm
BuildRequires: globus-gram-job-manager
# see https://bugzilla.altlinux.org/show_bug.cgi?id=10382
%define _localstatedir %{_var}
Name:		globus-gram-job-manager-condor
%global _name %(tr - _ <<< %{name})
Version:	3.0
Release:	alt2_22
Summary:	Grid Community Toolkit - Condor Job Manager Support

License:	Apache-2.0
URL:		https://github.com/gridcf/gct/
Source:		https://repo.gridcf.org/gct6/sources/%{_name}-%{version}.tar.gz
Source8:	README
BuildArch:	noarch

BuildRequires:	rpm-build-perl
BuildRequires:	perl-devel

Requires:	globus-gram-job-manager >= 13
Requires:	globus-gram-job-manager-scripts >= 4
Requires:	globus-gass-cache-program >= 5
Requires:	globus-gatekeeper >= 9

Requires(preun):	globus-gram-job-manager-scripts >= 4
Source44: import.info

%description
The Grid Community Toolkit (GCT) is an open source software toolkit used for
building grid systems and applications. It is a fork of the Globus Toolkit
originally created by the Globus Alliance. It is supported by the Grid
Community Forum (GridCF) that provides community-based support for core
software packages in grid computing.

The %{name} package contains:
Condor Job Manager Support

%prep
%setup -q -n %{_name}-%{version}

%build
export CONDOR_RM=%{_bindir}/condor_rm
export CONDOR_SUBMIT=%{_bindir}/condor_submit
%configure --disable-static \
	   --includedir=%{_includedir}/globus \
	   --libexecdir=%{_datadir}/globus \
	   --docdir=%{_docdir}/%{name} \
	   --with-perlmoduledir=%{perl_vendor_privlib} \
	   --with-condor-os=LINUX \
	   --with-condor-arch=""

%make_build

%install
%makeinstall_std

# Remove jobmanager-condor from install dir - leave it for admin configuration
rm %{buildroot}%{_sysconfdir}/grid-services/jobmanager-condor

# Install README file
install -m 644 -p %{SOURCE8} %{buildroot}%{_docdir}/%{name}/README

# Remove license file from pkgdocdir
rm %{buildroot}%{_docdir}/%{name}/GLOBUS_LICENSE

%preun
if [ $1 -eq 0 ]; then
    globus-gatekeeper-admin -d jobmanager-condor > /dev/null 2>&1 || :
fi

%files
%{_datadir}/globus/globus_gram_job_manager/condor.rvf
%dir %{perl_vendor_privlib}/Globus
%dir %{perl_vendor_privlib}/Globus/GRAM
%dir %{perl_vendor_privlib}/Globus/GRAM/JobManager
%{perl_vendor_privlib}/Globus/GRAM/JobManager/condor.pm
%config(noreplace) %{_sysconfdir}/globus/globus-condor.conf
%config(noreplace) %{_sysconfdir}/grid-services/available/jobmanager-condor
%dir %{_docdir}/%{name}
%doc %{_docdir}/%{name}/README
%doc --no-dereference GLOBUS_LICENSE

%changelog
