Group: Networking/WWW
# BEGIN SourceDeps(oneline):
BuildRequires(pre): rpm-build-perl
BuildRequires: perl(Globus/Core/Paths.pm) perl(Globus/GRAM/Error.pm) perl(Globus/GRAM/JobSignal.pm) perl(Globus/GRAM/JobState.pm) perl-podlators
# END SourceDeps(oneline)
BuildRequires: /usr/bin/pod2html
%add_findreq_skiplist /usr/share/perl5/Globus/GRAM/*.pm
%add_findreq_skiplist /usr/share/globus/globus-job-manager-script.pl
# see https://bugzilla.altlinux.org/show_bug.cgi?id=10382
%define _localstatedir %{_var}
Name:		globus-gram-job-manager-scripts
%global _name %(tr - _ <<< %{name})
Version:	7.3
Release:	alt2_14
Summary:	Grid Community Toolkit - GRAM Job ManagerScripts

License:	Apache-2.0
URL:		https://github.com/gridcf/gct/
Source:		https://repo.gridcf.org/gct6/sources/%{_name}-%{version}.tar.gz
Source8:	README
BuildArch:	noarch

BuildRequires:	rpm-build-perl
BuildRequires:	perl-devel
Source44: import.info


%package doc
Group: Documentation
Summary:	Grid Community Toolkit - GRAM Job ManagerScripts Documentation Files
BuildArch: noarch

%description
The Grid Community Toolkit (GCT) is an open source software toolkit used for
building grid systems and applications. It is a fork of the Globus Toolkit
originally created by the Globus Alliance. It is supported by the Grid
Community Forum (GridCF) that provides community-based support for core
software packages in grid computing.

The %{name} package contains:
GRAM Job ManagerScripts

%description doc
The Grid Community Toolkit (GCT) is an open source software toolkit used for
building grid systems and applications. It is a fork of the Globus Toolkit
originally created by the Globus Alliance. It is supported by the Grid
Community Forum (GridCF) that provides community-based support for core
software packages in grid computing.

The %{name}-doc package contains:
GRAM Job ManagerScripts Documentation Files

%prep
%setup -q -n %{_name}-%{version}

%build
%configure --disable-static \
	   --includedir=%{_includedir}/globus \
	   --libexecdir=%{_datadir}/globus \
	   --docdir=%{_docdir}/%{name} \
	   --with-perlmoduledir=%{perl_vendor_privlib}

%make_build

%install
%makeinstall_std

# Install README file
install -m 644 -p %{SOURCE8} %{buildroot}%{_docdir}/%{name}/README

# Remove license file from pkgdocdir
rm %{buildroot}%{_docdir}/%{name}/GLOBUS_LICENSE

# Remove libdir reference from noarch package
sed '/$libdir =/d' \
    -i $RPM_BUILD_ROOT%{_datadir}/globus/globus-job-manager-script.pl

%files
%{_sbindir}/globus-gatekeeper-admin
%dir %{_datadir}/globus
%{_datadir}/globus/globus-job-manager-script.pl
%dir %{perl_vendor_privlib}/Globus
%dir %{perl_vendor_privlib}/Globus/GRAM
%{perl_vendor_privlib}/Globus/GRAM/JobDescription.pm
%{perl_vendor_privlib}/Globus/GRAM/JobManager.pm
%{perl_vendor_privlib}/Globus/GRAM/StdioMerger.pm
%doc %{_mandir}/man8/globus-gatekeeper-admin.8*
%dir %{_docdir}/%{name}
%doc %{_docdir}/%{name}/README
%doc --no-dereference GLOBUS_LICENSE

%files doc
%doc %{_mandir}/man3/*
%dir %{_docdir}/%{name}
%dir %{_docdir}/%{name}/perl
%dir %{_docdir}/%{name}/perl/Globus
%dir %{_docdir}/%{name}/perl/Globus/GRAM
%doc %{_docdir}/%{name}/perl/Globus/GRAM/*.html
%doc --no-dereference GLOBUS_LICENSE

%changelog
