Group: System/Libraries
# BEGIN SourceDeps(oneline):
BuildRequires(pre): rpm-build-perl rpm-macros-fedora-compat
BuildRequires: perl-podlators pkgconfig(globus-xio-gsi-driver)
# END SourceDeps(oneline)
# see https://bugzilla.altlinux.org/show_bug.cgi?id=10382
%define _localstatedir %{_var}
Name:		globus-gram-protocol
%global _name %(tr - _ <<< %{name})
Version:	13.6
Release:	alt1_10
Summary:	Grid Community Toolkit - GRAM Protocol Library

License:	Apache-2.0
URL:		https://github.com/gridcf/gct/
Source:		https://repo.gridcf.org/gct6/sources/%{_name}-%{version}.tar.gz
Source8:	README

BuildRequires:	gcc
BuildRequires:	globus-common-devel >= 15
BuildRequires:	globus-io-devel >= 8
BuildRequires:	globus-gssapi-gsi-devel >= 10
BuildRequires:	globus-gss-assist-devel >= 8
BuildRequires:	doxygen
BuildRequires:	rpm-build-perl
BuildRequires:	perl-devel
#		Additional requirements for make check
BuildRequires:	openssl
Source44: import.info


%package devel
Group: Development/C
Summary:	Grid Community Toolkit - GRAM Protocol Library Development Files
Requires:	%{name} = %{version}-%{release}

%package doc
Group: Documentation
Summary:	Grid Community Toolkit - GRAM Protocol Library Documentation Files
BuildArch:	noarch

%description
The Grid Community Toolkit (GCT) is an open source software toolkit used for
building grid systems and applications. It is a fork of the Globus Toolkit
originally created by the Globus Alliance. It is supported by the Grid
Community Forum (GridCF) that provides community-based support for core
software packages in grid computing.

The %{name} package contains:
GRAM Protocol Library

%description devel
The Grid Community Toolkit (GCT) is an open source software toolkit used for
building grid systems and applications. It is a fork of the Globus Toolkit
originally created by the Globus Alliance. It is supported by the Grid
Community Forum (GridCF) that provides community-based support for core
software packages in grid computing.

The %{name}-devel package contains:
GRAM Protocol Library Development Files

%description doc
The Grid Community Toolkit (GCT) is an open source software toolkit used for
building grid systems and applications. It is a fork of the Globus Toolkit
originally created by the Globus Alliance. It is supported by the Grid
Community Forum (GridCF) that provides community-based support for core
software packages in grid computing.

The %{name}-doc package contains:
GRAM Protocol Library Documentation Files

%prep
%setup -q -n %{_name}-%{version}

%build
# Reduce overlinking
export LDFLAGS="-Wl,--as-needed -Wl,-z,defs %{?__global_ldflags}"

%configure --disable-static \
	   --includedir=%{_includedir}/globus \
	   --libexecdir=%{_datadir}/globus \
	   --docdir=%{_docdir}/%{name} \
	   --with-perlmoduledir=%{perl_vendor_privlib}

# Reduce overlinking
sed 's!CC \(.*-shared\) !CC \\\${wl}--as-needed \1 !' -i libtool

%make_build

%install
%makeinstall_std

# Remove libtool archives (.la files)
rm %{buildroot}%{_libdir}/*.la

# Install README file
install -m 644 -p %{SOURCE8} %{buildroot}%{_docdir}/%{name}/README

# Remove license file from pkgdocdir
rm %{buildroot}%{_docdir}/%{name}/GLOBUS_LICENSE

%check
GLOBUS_HOSTNAME=localhost %make_build check



%files
%{_libdir}/libglobus_gram_protocol.so.*
%dir %{perl_vendor_privlib}/Globus
%dir %{perl_vendor_privlib}/Globus/GRAM
%{perl_vendor_privlib}/Globus/GRAM/Error.pm
%{perl_vendor_privlib}/Globus/GRAM/JobSignal.pm
%{perl_vendor_privlib}/Globus/GRAM/JobState.pm
%dir %{_datadir}/globus
%{_datadir}/globus/globus-gram-protocol-constants.sh
%dir %{_docdir}/%{name}
%doc %{_docdir}/%{name}/README
%doc --no-dereference GLOBUS_LICENSE

%files devel
%{_includedir}/globus/*
%{_libdir}/libglobus_gram_protocol.so
%{_libdir}/pkgconfig/%{name}.pc

%files doc
%doc %{_mandir}/man3/*
%dir %{_docdir}/%{name}
%dir %{_docdir}/%{name}/html
%doc %{_docdir}/%{name}/html/*
%dir %{_docdir}/%{name}/perl
%dir %{_docdir}/%{name}/perl/Globus
%dir %{_docdir}/%{name}/perl/Globus/GRAM
%doc %{_docdir}/%{name}/perl/Globus/GRAM/*.html
%doc --no-dereference GLOBUS_LICENSE

%changelog
