Group: Other
# BEGIN SourceDeps(oneline):
BuildRequires(pre): rpm-build-python rpm-build-python3 rpm-macros-fedora-compat
BuildRequires: libltdl7-devel
# END SourceDeps(oneline)
%define fedora 38
# see https://bugzilla.altlinux.org/show_bug.cgi?id=10382
%define _localstatedir %{_var}
Name:		globus-net-manager
%global _name %(tr - _ <<< %{name})
Version:	1.7
Release:	alt3_13
Summary:	Grid Community Toolkit - Network Manager Library

License:	Apache-2.0
URL:		https://github.com/gridcf/gct/
Source:		https://repo.gridcf.org/gct6/sources/%{_name}-%{version}.tar.gz
Source8:	README

BuildRequires:	gcc
BuildRequires:	globus-common-devel >= 15.27
BuildRequires:	globus-xio-devel >= 5
%if %{?fedora}%{!?fedora:0} >= 30 || %{?rhel}%{!?rhel:0} >= 8
BuildRequires:	python3-devel
%else
BuildRequires:	python-devel
%endif
BuildRequires:	doxygen
BuildRequires:	perl-devel
BuildRequires:	perl(strict.pm)

Requires:	globus-common >= 15.27
Source44: import.info

%package devel
Group: Other
Summary:	Grid Community Toolkit - Network Manager Library Development Files
Requires:	%{name} = %{version}-%{release}

%package -n globus-xio-net-manager-driver
Group: Other
Summary:	Grid Community Toolkit - Globus XIO Network Manager Driver
Requires:	%{name} = %{version}-%{release}
Requires:	globus-xio >= 5

%package -n globus-xio-net-manager-driver-devel
Group: Other
Summary:	Grid Community Toolkit - Globus XIO Network Manager Driver Development Files
Requires:	globus-xio-net-manager-driver = %{version}-%{release}

%package doc
Group: Other
Summary:	Grid Community Toolkit - Network Manager Library Documentation Files
BuildArch:	noarch

%description
The Grid Community Toolkit (GCT) is an open source software toolkit used for
building grid systems and applications. It is a fork of the Globus Toolkit
originally created by the Globus Alliance. It is supported by the Grid
Community Forum (GridCF) that provides community-based support for core
software packages in grid computing.

The %{name} package contains:
Network Manager Library

The Globus Neteork Manager Library is a plug-in point for network management
tasks, such as:
 - selectively open ports in a firewall and allow these ports to be closed
   when transfers are complete
 - configure a virtual circuit based on a site policy and route traffic
   over this circuit
 - route network traffic related to a task over a particular network

%description devel
The Grid Community Toolkit (GCT) is an open source software toolkit used for
building grid systems and applications. It is a fork of the Globus Toolkit
originally created by the Globus Alliance. It is supported by the Grid
Community Forum (GridCF) that provides community-based support for core
software packages in grid computing.

The %{name}-devel package contains:
Network Manager Library Development Files

%description -n globus-xio-net-manager-driver
The Grid Community Toolkit (GCT) is an open source software toolkit used for
building grid systems and applications. It is a fork of the Globus Toolkit
originally created by the Globus Alliance. It is supported by the Grid
Community Forum (GridCF) that provides community-based support for core
software packages in grid computing.

The globus-xio-net-manager-driver package contains:
Globus XIO Network Manager Driver

%description -n globus-xio-net-manager-driver-devel
The Grid Community Toolkit (GCT) is an open source software toolkit used for
building grid systems and applications. It is a fork of the Globus Toolkit
originally created by the Globus Alliance. It is supported by the Grid
Community Forum (GridCF) that provides community-based support for core
software packages in grid computing.

The globus-xio-net-manager-driver-devel package contains:
Globus XIO Network Manager Driver Development Files

%description doc
The Grid Community Toolkit (GCT) is an open source software toolkit used for
building grid systems and applications. It is a fork of the Globus Toolkit
originally created by the Globus Alliance. It is supported by the Grid
Community Forum (GridCF) that provides community-based support for core
software packages in grid computing.

The %{name}-doc package contains:
Network Manager Library Documentation Files

%prep
%setup -q -n %{_name}-%{version}

%build
# Reduce overlinking
export LDFLAGS="-Wl,--as-needed -Wl,-z,defs %{?__global_ldflags}"

%if %{?fedora}%{!?fedora:0} >= 30 || %{?rhel}%{!?rhel:0} >= 8
export PYTHON_CONFIG=%{__python3}-config
%else
export PYTHON_CONFIG=%{__python}-config
%endif

%configure --disable-static \
	   --includedir=%{_includedir}/globus \
	   --libexecdir=%{_datadir}/globus \
	   --docdir=%{_docdir}/%{name} \
	   --enable-python

# Reduce overlinking
sed 's!CC \(.*-shared\) !CC \\\${wl}--as-needed \1 !' -i libtool

%make_build

%install
%makeinstall_std

# Remove libtool archives (.la files)
rm %{buildroot}%{_libdir}/*.la

# Install README file
install -m 644 -p %{SOURCE8} %{buildroot}%{_docdir}/%{name}/README

# Remove license file from pkgdocdir
rm %{buildroot}%{_docdir}/%{name}/GLOBUS_LICENSE

%check
GLOBUS_HOSTNAME=localhost PYTHONDONTWRITEBYTECODE=1 %make_build check





%files
%{_libdir}/libglobus_net_manager.so.*
%dir %{_docdir}/%{name}
%doc %{_docdir}/%{name}/README
%doc --no-dereference GLOBUS_LICENSE

%files devel
%{_includedir}/globus/globus_net_manager.h
%{_includedir}/globus/globus_net_manager_attr.h
%{_libdir}/libglobus_net_manager.so
%{_libdir}/pkgconfig/%{name}.pc

%files -n globus-xio-net-manager-driver
# This is a loadable module (plugin)
%{_libdir}/libglobus_xio_net_manager_driver.so

%files -n globus-xio-net-manager-driver-devel
%{_includedir}/globus/globus_xio_net_manager_driver.h
%{_libdir}/pkgconfig/globus-xio-net-manager-driver.pc

%files doc
%doc %{_mandir}/man3/*
%dir %{_docdir}/%{name}
%dir %{_docdir}/%{name}/html
%doc %{_docdir}/%{name}/html/*
%doc --no-dereference GLOBUS_LICENSE

%changelog
