Group: Networking/WWW
# BEGIN SourceDeps(oneline):
BuildRequires(pre): rpm-macros-fedora-compat
# END SourceDeps(oneline)
# see https://bugzilla.altlinux.org/show_bug.cgi?id=10382
%define _localstatedir %{_var}
Name:		globus-proxy-utils
%global _name %(tr - _ <<< %{name})
Version:	7.3
Release:	alt1_10
Summary:	Grid Community Toolkit - Globus GSI Proxy Utility Programs

License:	Apache-2.0
URL:		https://github.com/gridcf/gct/
Source:		https://repo.gridcf.org/gct6/sources/%{_name}-%{version}.tar.gz
Source8:	README
#		https://github.com/gridcf/gct/pull/237
Patch0:		0001-Fix-compilation-with-GCC-15-Fedora-42.patch

BuildRequires:	gcc
BuildRequires:	globus-common-devel >= 15
BuildRequires:	globus-openssl-module-devel >= 3
BuildRequires:	globus-gsi-openssl-error-devel >= 2
BuildRequires:	globus-gsi-cert-utils-devel >= 8
BuildRequires:	globus-gsi-sysconfig-devel >= 5
BuildRequires:	globus-gsi-credential-devel >= 5
BuildRequires:	globus-gsi-callback-devel >= 4
BuildRequires:	globus-gsi-proxy-core-devel >= 6
BuildRequires:	globus-gss-assist-devel >= 8
BuildRequires:	globus-gssapi-gsi-devel >= 4
BuildRequires:	libssl-devel
#		Additional requirements for make check
BuildRequires:	openssl
BuildRequires:	perl-devel
BuildRequires:	perl(File/Temp.pm)
BuildRequires:	perl(IO/Handle.pm)
BuildRequires:	perl(strict.pm)
BuildRequires:	perl(Test/More.pm)
Source44: import.info

%description
The Grid Community Toolkit (GCT) is an open source software toolkit used for
building grid systems and applications. It is a fork of the Globus Toolkit
originally created by the Globus Alliance. It is supported by the Grid
Community Forum (GridCF) that provides community-based support for core
software packages in grid computing.

The %{name} package contains:
Globus GSI Proxy Utility Programs

%prep
%setup -q -n %{_name}-%{version}
%patch0  -p5

%build
# Reduce overlinking
export LDFLAGS="-Wl,--as-needed -Wl,-z,defs %{?__global_ldflags}"

%configure --disable-static \
	   --includedir=%{_includedir}/globus \
	   --libexecdir=%{_datadir}/globus \
	   --docdir=%{_docdir}/%{name}

# Reduce overlinking
sed 's!CC \(.*-shared\) !CC \\\${wl}--as-needed \1 !' -i libtool

%make_build

%install
%makeinstall_std

# Install README file
install -m 644 -p %{SOURCE8} %{buildroot}%{_docdir}/%{name}/README

# Remove license file from pkgdocdir
rm %{buildroot}%{_docdir}/%{name}/GLOBUS_LICENSE

%check
%make_build check

%files
%{_bindir}/grid-cert-diagnostics
%{_bindir}/grid-proxy-destroy
%{_bindir}/grid-proxy-info
%{_bindir}/grid-proxy-init
%doc %{_mandir}/man1/grid-cert-diagnostics.1*
%doc %{_mandir}/man1/grid-proxy-destroy.1*
%doc %{_mandir}/man1/grid-proxy-info.1*
%doc %{_mandir}/man1/grid-proxy-init.1*
%dir %{_docdir}/%{name}
%doc %{_docdir}/%{name}/README
%doc --no-dereference GLOBUS_LICENSE

%changelog
