Group: System/Libraries
# BEGIN SourceDeps(oneline):
BuildRequires(pre): rpm-macros-fedora-compat
# END SourceDeps(oneline)
%define fedora 38
# see https://bugzilla.altlinux.org/show_bug.cgi?id=10382
%define _localstatedir %{_var}
%global _hardened_build 1

%if %{?fedora}%{!?fedora:0} >= 25 || %{?rhel}%{!?rhel:0} >= 8
%global use_systemd 1
%else
%global use_systemd 0
%endif

Name:		globus-scheduler-event-generator
%global _name %(tr - _ <<< %{name})
Version:	6.5
Release:	alt1_10
Summary:	Grid Community Toolkit - Scheduler Event Generator

License:	Apache-2.0
URL:		https://github.com/gridcf/gct/
Source:		https://repo.gridcf.org/gct6/sources/%{_name}-%{version}.tar.gz
Source1:	%{name}@.service
Source2:	%{name}
Source8:	README
#		https://github.com/gridcf/gct/pull/223
Patch0:		0001-Handle-64-bit-time_t-on-32-bit-systems.patch

BuildRequires:	gcc
BuildRequires:	globus-common-devel >= 15
BuildRequires:	globus-xio-devel >= 3
BuildRequires:	globus-gram-protocol-devel >= 11
BuildRequires:	globus-xio-gsi-driver-devel >= 2
BuildRequires:	libltdl7-devel
BuildRequires:	doxygen
%if %{use_systemd}
BuildRequires:	libsystemd-devel libudev-devel systemd systemd-analyze systemd-homed systemd-networkd
%endif
#		Additional requirements for make check
BuildRequires:	perl-devel
BuildRequires:	perl(File/Basename.pm)
BuildRequires:	perl(File/Compare.pm)
BuildRequires:	perl(File/Temp.pm)
BuildRequires:	perl(Test/More.pm)

Requires:	globus-xio-gsi-driver >= 2
Source44: import.info

%package progs
Group: Networking/WWW
Summary:	Grid Community Toolkit - Scheduler Event Generator Programs
Requires:	%{name} = %{version}-%{release}

%if %{use_systemd}
%{?systemd_requires}
%else
%endif

%package devel
Group: Development/C
Summary:	Grid Community Toolkit - Scheduler Event Generator Development Files
Requires:	%{name} = %{version}-%{release}

%package doc
Group: Documentation
Summary:	Grid Community Toolkit - Scheduler Event Generator Documentation Files
BuildArch:	noarch

%description
The Grid Community Toolkit (GCT) is an open source software toolkit used for
building grid systems and applications. It is a fork of the Globus Toolkit
originally created by the Globus Alliance. It is supported by the Grid
Community Forum (GridCF) that provides community-based support for core
software packages in grid computing.

The %{name} package contains:
Scheduler Event Generator

%description progs
The Grid Community Toolkit (GCT) is an open source software toolkit used for
building grid systems and applications. It is a fork of the Globus Toolkit
originally created by the Globus Alliance. It is supported by the Grid
Community Forum (GridCF) that provides community-based support for core
software packages in grid computing.

The %{name}-progs package contains:
Scheduler Event Generator Programs

%description devel
The Grid Community Toolkit (GCT) is an open source software toolkit used for
building grid systems and applications. It is a fork of the Globus Toolkit
originally created by the Globus Alliance. It is supported by the Grid
Community Forum (GridCF) that provides community-based support for core
software packages in grid computing.

The %{name}-devel package contains:
Scheduler Event Generator Development Files

%description doc
The Grid Community Toolkit (GCT) is an open source software toolkit used for
building grid systems and applications. It is a fork of the Globus Toolkit
originally created by the Globus Alliance. It is supported by the Grid
Community Forum (GridCF) that provides community-based support for core
software packages in grid computing.

The %{name}-doc package contains:
Scheduler Event Generator Documentation Files

%prep
%setup -q -n %{_name}-%{version}
%patch0  -p5

%build
# Reduce overlinking
export LDFLAGS="-Wl,--as-needed -Wl,-z,defs %{?__global_ldflags}"

%configure --disable-static \
	   --includedir=%{_includedir}/globus \
	   --libexecdir=%{_datadir}/globus \
	   --docdir=%{_docdir}/%{name} \
	   --with-initscript-config-path=%{_sysconfdir}/sysconfig/%{name} \
	   --with-lockfile-path=/run/lock/subsys/%{name}

# Reduce overlinking
sed 's!CC \(.*-shared\) !CC \\\${wl}--as-needed \1 !' -i libtool

%make_build

%install
%makeinstall_std

# Remove libtool archives (.la files)
rm %{buildroot}%{_libdir}/*.la

# Remove start-up scripts
rm -rf %{buildroot}%{_sysconfdir}/init.d

# Install start-up scripts
%if %{use_systemd}
mkdir -p %{buildroot}%{_unitdir}
install -m 644 -p %{SOURCE1} %{buildroot}%{_unitdir}
%else
mkdir -p %{buildroot}%{_initddir}
install -p %{SOURCE2} %{buildroot}%{_initddir}
%endif

# Install README file
install -m 644 -p %{SOURCE8} %{buildroot}%{_docdir}/%{name}/README

# Remove license file from pkgdocdir
rm %{buildroot}%{_docdir}/%{name}/GLOBUS_LICENSE

%check
%make_build check



%if %{use_systemd}

%pre progs
/sbin/chkconfig --del %{name} > /dev/null 2>&1 || :

%post progs
if [ $1 -eq 1 ] ; then
    systemctl daemon-reload > /dev/null 2>&1 || :
fi

%preun progs
if [ $1 -eq 0 ] ; then
    for INSTANCE in `systemctl | grep %{name}@ | awk '{print $1;}'`; do
	systemctl --no-reload disable $INSTANCE > /dev/null 2>&1 || :
	systemctl stop $INSTANCE > /dev/null 2>&1 || :
    done
fi

%postun progs
if [ $1 -ge 1 ] ; then
    systemctl daemon-reload > /dev/null 2>&1 || :
    for INSTANCE in `systemctl | grep %{name}@ | awk '{print $1;}'`; do
	systemctl try-restart $INSTANCE > /dev/null 2>&1 || :
    done
fi

%else

%post progs
if [ $1 -eq 1 ]; then
    /sbin/chkconfig --add %{name}
fi

%preun progs
if [ $1 -eq 0 ]; then
    /sbin/chkconfig --del %{name}
    /sbin/service %{name} stop > /dev/null 2>&1 || :
fi

%postun progs
if [ $1 -ge 1 ]; then
    /sbin/service %{name} condrestart > /dev/null 2>&1 || :
fi

%endif

%files
%{_libdir}/libglobus_scheduler_event_generator.so.*
%dir %{_docdir}/%{name}
%doc %{_docdir}/%{name}/README
%doc --no-dereference GLOBUS_LICENSE

%files progs
%{_sbindir}/globus-scheduler-event-generator
%{_sbindir}/globus-scheduler-event-generator-admin
%{_mandir}/man8/globus-scheduler-event-generator.8*
%{_mandir}/man8/globus-scheduler-event-generator-admin.8*
%config(noreplace) %{_sysconfdir}/sysconfig/%{name}
%if %{use_systemd}
%{_unitdir}/%{name}@.service
%else
%{_initddir}/%{name}
%endif
%dir %{_sysconfdir}/globus
%dir %{_sysconfdir}/globus/scheduler-event-generator
%dir %{_sysconfdir}/globus/scheduler-event-generator/available

%files devel
%{_includedir}/globus/*
%{_libdir}/libglobus_scheduler_event_generator.so
%{_libdir}/pkgconfig/%{name}.pc

%files doc
%doc %{_mandir}/man3/*
%dir %{_docdir}/%{name}
%dir %{_docdir}/%{name}/html
%doc %{_docdir}/%{name}/html/*
%doc --no-dereference GLOBUS_LICENSE

%changelog
