%global pluginname   datainjection

Name:           glpi-data-injection
Version:        2.2.4
Release:        alt1_2
Summary:        Plugin for importing data into GLPI
Summary(fr):    Extension pour importer des données dans GLPI

Group:          Networking/WWW
License:        GPLv2+

URL:            https://forge.indepnet.net/projects/datainjection
# This change for each new version
Source0:        https://forge.indepnet.net/attachments/download/1352/glpi-datainjection-2.2.4.tar.gz

BuildArch:      noarch

Requires:       glpi >= 0.83.3
Conflicts:      glpi >= 0.84
Requires:       glpi-pdf

# This plugin have been renamed
Provides:       glpi-%{pluginname} = %{version}-%{release}
Source44: import.info


%description
Plugin for importing data into GLPI

It'll can serve, for example, to :
- import machines at the delivery (electronic delivery order in CSV)
- import additional data
- import equipment not managed by OCS
- transmit from an other tool of asset management

%description -l fr
Extension pour importer des données dans GLPI

Elle pourra servir, par exemple, à :
- importer des machines à la livraison (bon de livraison électronique en CSV)
- importer des données complémentaires
- importer des matériels non gérés par OCS
- migrer depuis un autre outil de gestion de parc


%prep
%setup -q -c

mv %{pluginname}/docs docs

# dos2unix to avoid rpmlint warnings
for fic in docs/*; do
  mv $fic $fic.ref
  sed -e 's/\r//' $fic.ref >$fic
  touch -r $fic.ref $fic
  rm $fic.ref
done

# don't need this
rm -f testwebservice.php


%build
# empty build


%install

mkdir -p %{buildroot}/%{_datadir}/glpi/plugins
cp -ar %{pluginname} %{buildroot}/%{_datadir}/glpi/plugins/%{pluginname}

for i in %{buildroot}/%{_datadir}/glpi/plugins/%{pluginname}/locales/*
do
  lang=$(basename $i)
  echo "%lang(${lang:0:2}) %{_datadir}/glpi/plugins/%{pluginname}/locales/${lang}"
done | tee %{name}.lang

%files -f %{name}.lang
%doc docs/*
%dir %{_datadir}/glpi/plugins/%{pluginname}
%{_datadir}/glpi/plugins/%{pluginname}/*.php
%dir %{_datadir}/glpi/plugins/%{pluginname}/locales
%{_datadir}/glpi/plugins/%{pluginname}/ajax
%{_datadir}/glpi/plugins/%{pluginname}/css
%{_datadir}/glpi/plugins/%{pluginname}/front
%{_datadir}/glpi/plugins/%{pluginname}/inc
%{_datadir}/glpi/plugins/%{pluginname}/javascript
%{_datadir}/glpi/plugins/%{pluginname}/pics
# Need here, required from the Interface
%{_datadir}/glpi/plugins/%{pluginname}/LICENSE


%changelog
