# BEGIN SourceDeps(oneline):
BuildRequires: unzip
# END SourceDeps(oneline)
# see https://bugzilla.altlinux.org/show_bug.cgi?id=10382
%define _localstatedir %{_var}

Name:           glueminisat
Version:        2.2.8
Release:        alt1_7
Summary:        Boolean SAT solver that implements literal blocks distance (LBD)

License:        MIT
Group:          Engineering
URL:            http://glueminisat.nabelab.org/
# Fetching the URL below with recent releases of Chromium and Firefox works
# fine. However, fetching it with wget currently fails for me (with the
# message: "File name too long"). Including the -O option with the explicit
# filename for the tar ball seems to work around that issue. The URL provided
# by the GlueMiniSat download page has some additional HTTP GET parameters
# appended to it;  "?attredirects=0&d=1" (without the quotes). RPM doesn't
# seem to like them, so they are omitted from the URL tag value here.
Source0:        https://sites.google.com/a/nabelab.org/glueminisat/home/download/%{name}-%{version}.zip
# Simple test case input (from the 2004 International SAT Competition)
Source1:        %{name}-test.in
# Short HTML document that provides links to various online help resources
Source2:        %{name}-intro.html
# Don't try to set the FPU to double precision unless target CPU supports it
Patch0:         %{name}-FPU.patch
BuildRequires:  gcc-c++
BuildRequires:  zlib-devel
Source44: import.info

%description
GlueMiniSat is a boolean, propositional satisfiability (SAT) problem
solver. It is a derivative work of the open source MiniSat 2.2 solver,
and implements a form of the literal blocks distance (LBD) evaluation
criteria to predict the quality of clauses learned when conflicts are
encountered in the search process.

The underlying concepts of literal blocks distance were first introduced
in the paper "Predicting learnt clauses quality in modern SAT solvers"
by Gilles Audemard and Laurent Simon, Proceedings of IJCAI-2009, pages
399-404, 2009. The authors' implementation of LBD, the Glucose 1.0 SAT
solver, performed admirably by placing 2-nd at the International 2009
SAT competition in the Applications (UNSAT) category.

GlueMiniSat uses a slightly restricted concept of LBD, called strict
LBD, and a dynamic restart strategy based on local averages of the
decision levels and the LBDs of learned clauses. Experimental results
show that GlueMiniSat also performs very well on SAT instances that
are unsatisfiable.  GlueMiniSat earned 1-st place at the International
2011 SAT competition in the Applications (UNSAT) category, solving 126
of 142 problem instances.

GlueMiniSat supports the same command line options as MiniSat 2.2 (see the
documentation from the minisat2 package). It can also run as a "clone"
of the MiniSat 2.2 or Glucose 1.0 SAT solvers by specifying the command
line options -minisat or -glucose, respectively.

%prep
%setup -q
%patch0 -p1 -b .orig
cp -p %{SOURCE1} .
cp -p %{SOURCE2} .

%build
# Build the "core" executable, (which omits the simplification capabilities)
# The target "r" signifies that we are building the "release" version
%make_build -C code/core r \
  MROOT=`pwd`/code \
  COPTIMIZE="${RPM_OPT_FLAGS}" \
  LFLAGS="${RPM_OPT_FLAGS} -lz"
cp -p code/core/%{name}-core-release %{name}_core
# Build the "simp" executable, (which includes the simplification capabilities)
# The target "r" signifies that we are building the "release" version
%make_build -C code/simp r \
  MROOT=`pwd`/code \
  COPTIMIZE="${RPM_OPT_FLAGS}" \
  LFLAGS="${RPM_OPT_FLAGS} -lz"
cp -p code/simp/%{name}-simp-release %{name}_simp

%install
mkdir -p ${RPM_BUILD_ROOT}%{_bindir}
# Install %{name}_core as a specific alternative for the generic name %{name}
install -m 0755 %{name}_core ${RPM_BUILD_ROOT}%{_bindir}/%{name}_core
# Install %{name}_simp as a specific alternative for the generic name %{name}
install -m 0755 %{name}_simp ${RPM_BUILD_ROOT}%{_bindir}/%{name}_simp
# Touch the generic path name (to be installed as a ghosted file)
touch ${RPM_BUILD_ROOT}%{_bindir}/%{name}

# touching all ghosts; hack for rpm 4.0.4
for rpm404_ghost in %{_bindir}/%{name}
do
    mkdir -p %buildroot`dirname "$rpm404_ghost"`
    touch %buildroot"$rpm404_ghost"
done
install -d $RPM_BUILD_ROOT/%_altdir; cat >$RPM_BUILD_ROOT/%_altdir/%{name}_glueminisat<<EOF
%{_bindir}/%{name}	%{_bindir}/%{name}_simp	60
EOF
install -d $RPM_BUILD_ROOT/%_altdir; cat >$RPM_BUILD_ROOT/%_altdir/%{name}_glueminisat<<EOF
%{_bindir}/%{name}	%{_bindir}/%{name}_core	40
EOF

# Installation/removal in the alternatives system is done by post/preun below

%check
# The test file "glueminisat-test.in" is a brief quote from
# http://www.satcompetition.org/2004/format-solvers2004.html
# Exit value is 10 for satisfiable, 20 for unsatisfiable
./glueminisat_core glueminisat-test.in glueminisat-test-core.out || true
echo "TEST RESULTS (core):"
cat glueminisat-test-core.out
result_core=`head -1 glueminisat-test-core.out`
./glueminisat_simp glueminisat-test.in glueminisat-test-simp.out || true
echo "TEST RESULTS (simp):"
cat glueminisat-test-simp.out
result_simp=`head -1 glueminisat-test-simp.out`
if [ "$result_core" = "SAT" -a "$result_simp" = "SAT" ]; then
  echo "SUCCESS - all of the tests succeeded."
  true
else
  echo "Failed one or more of the tests."
  false
fi

%files
%_altdir/%{name}_glueminisat
%_altdir/%{name}_glueminisat
%doc license.txt readme.txt %{name}-intro.html
%doc %{name}-test.in %{name}-test-core.out %{name}-test-simp.out
%attr(755,root,root) %{_bindir}/%{name}_core
%attr(755,root,root) %{_bindir}/%{name}_simp

%changelog
