Group: Other
# see https://bugzilla.altlinux.org/show_bug.cgi?id=10382
%define _localstatedir %{_var}
Name:           gmqcc
Version:        0.3.5
Release:        alt2_24
Summary:        Improved Quake C Compiler
License:        MIT
URL:            http://graphitemaster.github.io/gmqcc/
Source0:        https://github.com/graphitemaster/%{name}/archive/%{version}.tar.gz#/%{name}-%{version}.tar.gz
# fix build on big endian arches - stdlib.h required for exit()
Patch0:         %{name}-0.3.5-stdlib.patch

# From old-stable branch in upstream
Patch0001:      0001-clean-include-.d.patch
Patch0002:      0002-Add-GMQCC_FUNCTION.patch
Patch0003:      0003-Add-GMQCC_FALLTHROUGH.patch
Patch0004:      0004-Disable-Werror-for-old-stable.patch
Patch0005:      0005-sanitize-use-1u-unsigned-for-flag-bit-shifts.patch
Patch0006:      0006-sanitize-util_hthash-with-a-hack.patch

# tests fail on big endians
ExclusiveArch:  %{ix86} x86_64 %{arm} aarch64

BuildRequires:  gcc
BuildRequires:  valgrind-devel valgrind-tool-devel
Source44: import.info

%description
Modern written-from-scratch compiler for the QuakeC language with
support for many common features found in other QC compilers.

%package -n qcvm
Group: Other
Summary:        Standalone QuakeC VM binary executor

%description -n qcvm
Executor for QuakeC VM binary files created using a QC compiler such
as gmqcc or fteqcc. It provides a small set of built-in functions, and
by default executes the main function if there is one. Some options
useful for debugging are available as well.

%package -n gmqpak
Group: Other
Summary:        Standalone Quake PAK file utility

%description -n gmqpak
Standalone Quake PAK file utility supporting the extraction of files,
directories, or whole PAKs, as well as the opposite (creation of PAK files).

%prep
%setup -q
%patch0 -p1
%patch1 -p1
%patch2 -p1
%patch3 -p1
%patch4 -p1
%patch5 -p1
%patch6 -p1


# and for all for all of those switches they increase the runtime of the compile
# making compiles of code slower

# we don't need compiel time buffer protection, we test with clangs address
# sanatizer and valgrind before releases
%global optflags %(echo %{optflags} | sed 's/-Wp,-D_FORTIFY_SOURCE=2 //')
# there is no exceptions in C
%global optflags %(echo %{optflags} | sed 's/-fexceptions //')
# same with clangs address sanatizer and valgrind testing
%global optflags %(echo %{optflags} | sed 's/-fstack-protector-strong //')

%build

%make_build

%install
%makeinstall_std PREFIX=%{_prefix}

%check
make check

%files
%doc --no-dereference LICENSE
%doc README AUTHORS CHANGES TODO
%doc gmqcc.ini.example
%{_mandir}/man1/gmqcc.1*
%{_bindir}/gmqcc

%files -n qcvm
%doc --no-dereference LICENSE
%doc README AUTHORS CHANGES TODO
%{_mandir}/man1/qcvm.1*
%{_bindir}/qcvm

%files -n gmqpak
%doc --no-dereference LICENSE
%doc README AUTHORS CHANGES TODO
%{_mandir}/man1/gmqpak.1*
%{_bindir}/gmqpak

%changelog
