# see https://bugzilla.altlinux.org/show_bug.cgi?id=10382
%define _localstatedir %{_var}
Name:       gnome-encfs-manager
Version:    1.8.18
Release:    alt1_2
Summary:    An easy to use manager and mounter for encfs stashes
Group:      Graphical desktop/GNOME
License:    GPLv2+
URL:        http://www.libertyzero.com/GEncfsM
Source:     https://launchpad.net/gencfsm/trunk/1.8/+download/%{name}_%{version}.tar.xz
Patch0:     gnome-encfs-manager-1.8.12.2-fix-desktop-entry.patch
Patch1:     gnome-encfs-manager-1.8.18-mga-vala-0.36.patch

Requires: fuse-encfs

BuildRequires: intltool
BuildRequires: gettext gettext-tools
BuildRequires: libtool
BuildRequires: vala
BuildRequires: pkgconfig(gtk+-3.0)
BuildRequires: pkgconfig(gee-1.0)
BuildRequires: pkgconfig(gmodule-2.0)
BuildRequires: pkgconfig(gio-2.0)
BuildRequires: pkgconfig(gnome-keyring-1)
BuildRequires: pkgconfig(sm)
BuildRequires: pkgconfig(ice)
Source44: import.info

%description
The Gnome Encfs Manager is a manager and mounter for encfs stashes. It features:

  * an easy and quick to use tray icon inspired by Cryptkeeper
  * Gnome keyring support
  * per-stash configuration for all features
  * automatic mounting and unmounting, when a stash gets available / unavailable
    (e.g. when you insert a usb drive containing a configured stash)
  * an intuitive interface to create, configure and import stashes
  * automount-at-startup support

%prep
%setup -q
%patch0 -p1
%patch1 -p1

%build
./autogen.sh
%configure --disable-appindicator
%make_build

%install
%makeinstall_std

rm -rf %{buildroot}%{_datadir}/icons/Mint-X
rm -rf %{buildroot}%{_datadir}/icons/ubuntu*

%find_lang %{name}

%files -f %{name}.lang
%{_bindir}/gnome-encfs-manager
%{_datadir}/applications/gnome-encfs-manager.desktop
%{_datadir}/glib-2.0/schemas/com.libertyzero.gnome-encfs-manager.gschema.xml
%{_datadir}/dbus-1/services/com.libertyzero.gnome-encfs-manager.service
%{_datadir}/gnome-encfs-manager
%{_datadir}/icons/hicolor/*/status/*.svg
%{_datadir}/icons/hicolor/scalable/apps/gnome-encfs-manager.svg


%changelog
