Group: Other
# BEGIN SourceDeps(oneline):
BuildRequires: /usr/bin/dbus-binding-tool /usr/bin/desktop-file-install /usr/bin/gconftool-2 /usr/bin/glib-genmarshal /usr/bin/glib-gettextize pkgconfig(dbus-glib-1) pkgconfig(glib-2.0) pkgconfig(gmodule-2.0) pkgconfig(gobject-2.0) pkgconfig(gthread-2.0)
# END SourceDeps(oneline)
# see https://bugzilla.altlinux.org/show_bug.cgi?id=10382
%define _localstatedir %{_var}
Name:		gnome-phone-manager
Summary:	Gnome Phone Manager
Version: 	0.69
Release: 	alt5_43
License: 	GPL-2.0-or-later
Source:		http://ftp.gnome.org/pub/GNOME/sources/gnome-phone-manager/%{version}/%{name}-%{version}.tar.xz
#Using git clone plus patch from GNOME BZ 680927.
#Source:		gnome-phone-manager-0.68-20120806git16211d.tar.xz
URL: 		https://wiki.gnome.org/PhoneManager/
BuildRequires:	gtk3-demo libgail3-devel libgtk+3 libgtk+3-devel libgtk+3-gir-devel
BuildRequires:	libcanberra-devel libcanberra-gtk-common-devel libcanberra-gtk2-devel libcanberra-gtk3-devel libcanberra-vala
BuildRequires:	libgnome-bluetooth3.0-devel libgnome-bluetooth3.0-gir-devel libgnome-bluetooth3.0-ui-devel
BuildRequires:	libbluez-devel
BuildRequires:	libgnokii-devel
BuildRequires:	gstreamer1.0-devel libgstreamer1.0-gir-devel
BuildRequires:	gnome-icon-theme
BuildRequires:	evolution-data-server-devel evolution-data-server-gir-devel evolution-data-server-vala
BuildRequires:	libgtkspell-devel
BuildRequires:	libtelepathy-glib-devel libtelepathy-glib-gir-devel
BuildRequires:	intltool perl(XML/Parser.pm)
BuildRequires:	gettext-tools
BuildRequires:	desktop-file-utils
BuildRequires:	libGConf-devel libGConf-gir-devel
BuildRequires:	pkgconfig(gnome-bluetooth-1.0)

#Patch01: gnome-phone-manager-0.66-no-g-thread-init.patch
#Patch02: gnome-phone-manager-0.66-bluetooth-api-change.patch
Patch03: gnome-phone-manager-0.68-eds.patch
Patch04: gnome-phone-manager-0.69-drop-plugin.patch
Source44: import.info

%description
This program will connect to your mobile phone over a serial port,
either via a cable, infrared (IrDA) or Bluetooth connection.

For example it listens for text messages, and when they arrive,
displays them on the desktop. A visual indicator is displayed in
the notification area, if one is presently added to the panel.

%package telepathy
Group: Other
Summary: Telepathy connection manager to send and receive SMSes

%description telepathy
This program will connect to your mobile phone over a serial port,
either via a cable, infrared (IrDA) or Bluetooth connection.

This plugin to Telepathy allows you to send and receive messages using any
Instant Messaging application that uses Telepathy, such as Empathy.

%prep
%setup -q

#%patch01 -p1 -b .no-g-thread-init
#%patch02 -p1 -b .bluetooth-api-change
%patch03 -p1 -b .eds
%patch4 -p0 -b .plugin

#rm ./libgsm/phonemgr-listener.lo
#rm ./libgsm/phonemgr-listener.o

%build
%configure
%make_build

%install
make DESTDIR=$RPM_BUILD_ROOT install

# This should be in empathy instead
install -m0644 -D telepathy/sms.profile $RPM_BUILD_ROOT%{_datadir}/mission-control/profiles/sms.profile

# Register as an application to be visible in the software center
#
# NOTE: It would be *awesome* if this file was maintained by the upstream
# project, translated and installed into the right place during `make install`.
#
# See http://www.freedesktop.org/software/appstream/docs/ for more details.
#
mkdir -p $RPM_BUILD_ROOT%{_datadir}/appdata
cat > $RPM_BUILD_ROOT%{_datadir}/appdata/%{name}.appdata.xml <<EOF
<?xml version="1.0" encoding="UTF-8"?>
<!-- Copyright 2014 Ryan Lerch <rlerch@redhat.com> -->
<!--
BugReportURL: https://bugzilla.gnome.org/show_bug.cgi?id=730849
SentUpstream: 2014-09-17
-->
<application>
  <id type="desktop">gnome-phone-manager.desktop</id>
  <metadata_license>CC0-1.0</metadata_license>
  <summary>Control your mobile phone from your desktop</summary>
  <description>
    <p>
      Phone Manager allows you to control your mobile phone. It uses the
      gnokii backend that typically works with older Nokia devices. Phone
      manager allows you to send SMS messages, view the address book on your
      phone, and receive notifications on the desktop when a new SMS arrives.
    </p>
  </description>
  <url type="homepage">https://live.gnome.org/PhoneManager/</url>
  <screenshots>
    <screenshot type="default">https://wiki.gnome.org/PhoneManager?action=AttachFile&amp;do=get&amp;target=prefs-2.png</screenshot>
  </screenshots>
</application>
EOF

rm $RPM_BUILD_ROOT%{_libdir}/gnome-bluetooth/plugins/libphonemgr.a
rm $RPM_BUILD_ROOT%{_libdir}/gnome-bluetooth/plugins/libphonemgr.la

%find_lang %{name}
desktop-file-install \
  --delete-original \
  --dir $RPM_BUILD_ROOT%{_datadir}/applications \
  $RPM_BUILD_ROOT%{_datadir}/applications/gnome-phone-manager.desktop

%post
export GCONF_CONFIG_SOURCE=`gconftool-2 --get-default-source`
gconftool-2 --makefile-install-rule \
        %{_sysconfdir}/gconf/schemas/gnome-phone-manager.schemas 	\
	>& /dev/null || :

%pre
if [ "$1" -gt 1 ]; then
    export GCONF_CONFIG_SOURCE=`gconftool-2 --get-default-source`
    gconftool-2 --makefile-uninstall-rule 				\
        %{_sysconfdir}/gconf/schemas/gnome-phone-manager.schemas 	\
	>& /dev/null || :
fi

%preun
if [ "$1" -eq 0 ]; then
    export GCONF_CONFIG_SOURCE=`gconftool-2 --get-default-source`
    gconftool-2 --makefile-uninstall-rule 				\
        %{_sysconfdir}/gconf/schemas/gnome-phone-manager.schemas 	\
	>& /dev/null || :
fi

%files -f %{name}.lang
%doc AUTHORS COPYING ChangeLog NEWS README TODO
%{_sysconfdir}/gconf/schemas/gnome-phone-manager.schemas
%{_bindir}/gnome-phone-manager
%{_datadir}/appdata/*.appdata.xml
%{_datadir}/applications/*.desktop
%{_datadir}/gnome-phone-manager/
%{_mandir}/man1/gnome-phone-manager.1*
%{_libdir}/gnome-bluetooth/plugins/libphonemgr.so

%files telepathy
%{_libexecdir}/telepathy-phoney
%{_datadir}/telepathy/managers/*
%{_datadir}/dbus-1/services/*
%{_datadir}/mission-control/profiles/*

%changelog
