Group: Graphical desktop/Other
%define fedora 25
# see https://bugzilla.altlinux.org/show_bug.cgi?id=10382
%define _localstatedir %{_var}
%global  gnome_extensions_dir        %{_datadir}/gnome-shell/extensions/
%global  WindowOverlay_UUID          windowoverlay-icons@sustmidown.centrum.cz
%global  WindowOverlay_destination   %{buildroot}/%{gnome_extensions_dir}/%{WindowOverlay_UUID}
%global  HistoryManager_UUID         historymanager-prefix-search@sustmidown.centrum.cz
%global  HistoryManager_destination  %{buildroot}/%{gnome_extensions_dir}/%{HistoryManager_UUID}
%global  commit                      e3def68fca56210f02b614c1d27780ba0467ceb3
%global  short_commit                e3def68

Name:       gnome-shell-extension-sustmi
Summary:    Include two extensions, windowoverlay-icons and historymanager-prefix-search
Version:    3.0
Release:    alt1_16.git.%{short_commit}
URL:        https://github.com/sustmi/gnome-shell-extensions-sustmi
License:    GPLv3+
BuildArch:  noarch

# For now, the latest commit can be seen here: https://github.com/sustmi/gnome-shell-extensions-sustmi/commits/master
# Eventually, I'd like to split these into fully separate packages, but they're committed together in the same GitHub repo, and I don't see a way to check release versions of the individual extensions on the "EGO" website. Maybe sustmi will be willing to start tagging releases or something.
Source0: https://github.com/sustmi/gnome-shell-extensions-sustmi/archive/%{commit}.tar.gz

BuildRequires: gettext gettext-tools
Source44: import.info

%description
This package provides two GNOME Shell extensions, windowoverlay-icons
and historymanager-prefix-search



%package   windowoverlay-icons
Group: Graphical desktop/Other
Summary:   Show app icons on top of the windows thumbnails in Activities Overview
Requires:  gnome-shell >= 3.8

# (CentOS 7 build environment doesn't support Recommends tag.)
%if 0%{?fedora}
Requires: gnome-tweak-tool
%endif

# CentOS 7 doesn't automatically do gschema compilation yet.
%if 0%{?rhel}
BuildRequires: libgio
%endif

%description  windowoverlay-icons
Sometimes when you have many open windows, especially if they all
contain a lot of text, the windows all start to look the same in the
Activities Overview. WindowOverlay Icons adds the application icon to
every window thumbnail, making it easier to tell them apart.

**NOTE:** After installing, each user that wants WindowOverlay Icons
must still enable the extension before it will take effect. You can do
so a few different ways:

* If you've already installed the GNOME Shell integration web browser
  plugin, go to <https://extensions.gnome.org/local/>, find the
  extension, and click the switch to "ON."
* Open GNOME Tweak Tool, go to the Extensions tab, find the extension,
  and click the switch to "ON."
* Open a terminal or the desktop's command dialog and run:
  gnome-shell-extension-tool --enable windowoverlay-icons@sustmidown.centrum.cz

You may also need to restart GNOME Shell (open the command dialog with
Alt-F2, type `r`, and hit enter), or log out and log back in.



%package   historymanager-prefix-search
Group: Graphical desktop/Other
Summary:   Use PageUp and PageDown to search for previous GNOME Shell commands
Requires:  gnome-shell >= 3.8

# (CentOS 7 build environment doesn't support Recommends tag.)
%if 0%{?fedora}
Requires: gnome-tweak-tool
%endif

# CentOS 7 doesn't automatically do gschema compilation yet.
%if 0%{?rhel}
BuildRequires: libgio
%endif

%description  historymanager-prefix-search
The GNOME Shell Run Command dialog (Alt-F2) and Looking Glass let you
cycle through the history of previous commands with the arrow keys, but
there's currently no built-in way to search or do autocompletion for
commands. With HistoryManager Prefix Search, you can type the beginning
of a command, and then hit the PageUp and PageDown keys to cycle through
previous commands which match the prefix you typed.

**NOTE:** After installing, each user that wants WindowOverlay Icons
must still enable the extension before it will take effect. You can do
so a few different ways:

* If you've already installed the GNOME Shell integration web browser
  plugin, go to <https://extensions.gnome.org/local/>, find the
  extension, and click the switch to "ON."
* Open GNOME Tweak Tool, go to the Extensions tab, find the extension,
  and click the switch to "ON."
* Open a terminal or the desktop's command dialog and run:
  gnome-shell-extension-tool --enable historymanager-prefix-search@sustmidown.centrum.cz

You may also need to restart GNOME Shell (open the command dialog with
Alt-F2, type `r`, and hit enter), or log out and log back in.



%prep
%setup -q -n gnome-shell-extensions-sustmi-%{commit}



%build
# Nothing to build.

%install
# Install WindowOverlay Icons.
mkdir -p %{WindowOverlay_destination}
mkdir -p %{buildroot}/%{_datadir}/glib-2.0/schemas/
cp --recursive --preserve=mode,timestamps  windowoverlay-icons/*  \
  %{WindowOverlay_destination}/

# Move gschemas to the system directory.
mv  %{WindowOverlay_destination}/schemas/org.gnome.shell.extensions.windowoverlay-icons.gschema.xml  \
  %{buildroot}/%{_datadir}/glib-2.0/schemas/
rm --recursive %{WindowOverlay_destination}/schemas/

# WindowOverlay Icons localizations.
rm --recursive %{WindowOverlay_destination}/po/
mv  %{WindowOverlay_destination}/locale/  %{buildroot}/%{_datadir}/
%find_lang windowoverlay-icons

# Install HistoryManager Prefix Search.
mkdir -p %{HistoryManager_destination}
cp --recursive --preserve=mode,timestamps  historymanager-prefix-search/*  \
  %{HistoryManager_destination}/
# historymanager doesn't have any schemas (for now?).
# historymanager doesn't have any translations because it has not visible text.


%files  windowoverlay-icons  -f windowoverlay-icons.lang
%doc COPYING
%{gnome_extensions_dir}/%{WindowOverlay_UUID}/
%{_datadir}/glib-2.0/schemas/org.gnome.shell.extensions.windowoverlay-icons.gschema.xml


%files  historymanager-prefix-search
%doc COPYING
%{gnome_extensions_dir}/%{HistoryManager_UUID}/





%changelog
