Group: Networking/WWW
# BEGIN SourceDeps(oneline):
BuildRequires(pre): rpm-build-perl
BuildRequires: /usr/bin/autoconf libreadline-devel perl(CGI/Carp.pm) perl(Compress/Zlib.pm) perl(Crypt/CBC.pm) perl(DBD/SQLite.pm) perl(DBI.pm) perl(Data/Properties.pm) perl(Digest/HMAC.pm) perl(Digest/SHA1.pm) perl(Error.pm) perl(Log/Log4perl.pm) perl(SOAP/Lite.pm) perl(XML/LibXML.pm) perl-podlators
# END SourceDeps(oneline)
# internal Gold.pm
AutoReq: yes,noperl
AutoProv: yes,noperl
%add_findreq_skiplist %{perl_vendor_privlib}/Gold*pm
%add_findreq_skiplist %{_datadir}/gold*cgi
BuildRequires: perl(CGI.pm) perl(CGI/Session.pm)

# see https://bugzilla.altlinux.org/show_bug.cgi?id=10382
%define _localstatedir %{_var}
# %%name and %%version is ahead of its definition. Predefining for rpm 4.0 compatibility.
%define name gold
%define version 2.1.12.2
%define goldcgidir	%{_datadir}/%{name}-%{version}
%define golddatadir	%{_localstatedir}/lib/%{name}
%{!?_pkgdocdir: %global _pkgdocdir %{_docdir}/%{name}-%{version}}

Name:		gold
Version:	2.1.12.2
Release:	alt2_41
Summary:	Tracks and manages resource usage on High Performance Computers
License:	BSD
URL:		http://www.clusterresources.com/products/%{name}
Source0:	http://www.clusterresources.com/downloads/%{name}/%{name}-%{version}.tar.gz
# These patches are to make it build happily under rpm and mock - they have
# been submitted upstream (see the thread at
# http://www.supercluster.org/pipermail/gold-users/2010-July/000343.html for
# more info).
Patch0:		gold-makefile.patch
Patch1:		gold-configure-ac.patch

BuildArch:	noarch 
Requires(pre):	shadow-change shadow-check shadow-convert shadow-edit shadow-groups shadow-log shadow-submap shadow-utils
Requires:	sqlite3

# For some reason, these requires are missed:
Requires:	perl(Data/Properties.pm)
Requires:	perl(Crypt/DES_EDE3.pm)

BuildRequires:  gcc
BuildRequires:	autoconf
BuildRequires:	coreutils
BuildRequires:	rpm-build-perl
BuildRequires:	perl-devel
Source44: import.info

%description
The Gold Allocation Manager is an open source accounting system developed by
Pacific Northwest National Laboratory (PNNL) as part of the Department of
Energy (DOE) Scalable Systems Software Project (SSS). It tracks resource usage
on High Performance Computers and acts much like a bank, establishing accounts
in order to pre-allocate user and project resource usage over specific nodes and
time-frame. Gold provides balance and usage feedback to users, managers, and
system administrators.  SQLite is used by default, but Gold can be configured
to use either MySQL or PostgreSQL instead.

%package web
Group: Networking/WWW
Summary:			Gold Allocation Manager Web Frontend
Requires:			%{name} = %{version}-%{release}
Requires:			webserver
BuildRequires:		perl-devel

%description web
CGI Perl web front-end for the Gold Allocation Manager.

%package doc
Group: Documentation
Summary:			Gold Allocation Manager Documentation
BuildArch: noarch

%description doc
Documentation for the Gold Allocation Manager.

%prep 
%setup -q
%patch0
%patch1
# Regenerate configure script
autoconf -f -o configure

%build
%configure \
	--with-user=gold --with-db=SQLite \
	--with-doc-dir=%{_docdir}/%{name} \
	--with-perl-libs=vendor --with-gold-libs=vendor --with-cgi-bin=%{goldcgidir} \
	--datadir=%{golddatadir}
%make_build
%make_build gui

# Prevent spurious requirement on Postgres DBD class
cat << \EOF > %{name}-req
#!/bin/sh
%{__perl_requires} $* |\
sed -e '/perl(DBD::Pg)/d'
EOF

%global __perl_requires %{_builddir}/%{name}-%{version}/%{name}-req
chmod +x %{__perl_requires}

%install
## Install documentation
mkdir -p %{buildroot}%{_docdir}/%{name}

## Install binaries
mkdir -p %{buildroot}%{golddatadir}
mkdir -p %{buildroot}%{perl_vendor_privlib}
make install DESTDIR=%{buildroot}

## Install web gui
make install-gui DESTDIR=%{buildroot}

# TODO
#make auth_key DESTDIR=%{buildroot}

# Clean up things that shouldn't have been installed
rm %{buildroot}%{perl_vendor_privlib}/Gold/*.pm.in

# Fix non UTF-8 files(preserving timestamps)
for i in README LICENSE;
do
	iconv -f iso8859-1 -t utf8 $i >$i.utf8
	touch -r $i $i.utf8
	mv $i.utf8 $i
done

# Install rest of the documentation
install -pm 644 README INSTALL LICENSE DATABASE CHANGES \
	%{buildroot}%{_docdir}/%{name}
cp -pR doc/ %{buildroot}%{_docdir}/%{name}

# TODO Separate out the gold server and client packages

# TODO Work out why init script isn't installing - in src/etc/gold.d.in
# TODO chkconfig --add gold
# TODO Patch Perl in /usr/sbin/goldd to use the passed in pid file and not the
# hard coded one!!
# TODO Patch Perl in /usr/sbin/goldd to use the correct path for the /etc/
# files!
# TODO Patch Perl in Gold.pm and others too as paths to the config files are
# incorrect.
# TODO Correct init script to use the correct path for the pid file -
# /var/run/gold/gold.pid or /var/run/gold.pid

# TODO Correct goldsh so that the gold_history file isn't in a hard-coded
# location in /usr/log/.gold_history or similar

# TODO Sort out the authkey: ${GOLD_HOME}/etc/auth_key (line 220 of
# /usr/sbin/goldd)

# TODO On the client end, make sure the default logging is to use syslog, and
# that this is honoured in all the places it is currently hard-coded!

# TODO The gold*.conf config files need to have their permissions changed so
# that they belong to the gold user and group and are chmod 600 or similar as
# they will contain database usernames and passwords.

# TODO Change the server name set in the config files
# TODO Change the log location set in the config files
# TODO Change the logging level set in the config files

# The server configuration file is goldd.conf
# The client is 
# The web interface configuration file is 


%check
# This target, although it exists, does nothing at present
make test

%pre
getent group gold >/dev/null || groupadd -r gold
## Add the "gold" user
getent passwd gold >/dev/null || \
/usr/sbin/useradd -c "Gold Allocation Manager" -g gold \
	-s /sbin/nologin -r -d %{_localstatedir}/lib/%{name} gold 
exit 0

%preun
if [ "$1" = 0 ]
then
	/sbin/service gold stop >/dev/null 2>&1 || :
	/sbin/chkconfig --del gold
fi

%files
%dir %{_docdir}/%{name}
%{_docdir}/%{name}/LICENSE
%dir %{golddatadir}
%dir %{perl_vendor_privlib}/Gold
%config(noreplace) %{_sysconfdir}/*
%{_bindir}/*
%{_sbindir}/*
%{perl_vendor_privlib}/Gold.pm
%{perl_vendor_privlib}/Gold/*.pm

%files doc
%dir %{_docdir}/%{name}
%{_docdir}/%{name}/*

%files web
%dir %{goldcgidir}
%{goldcgidir}/*

%changelog
