Group: Sound
# BEGIN SourceDeps(oneline):
BuildRequires: /usr/bin/valgrind rpm-build-python3
# END SourceDeps(oneline)
# see https://bugzilla.altlinux.org/show_bug.cgi?id=10382
%define _localstatedir %{_var}
%global gstversion 1.0
%global gst_minver 1.0.0

Name:           gst-entrans
Version:        1.4.1
Release:        alt1_5
Summary:        Plug-ins and tools for transcoding and recording with GStreamer

License:        LGPLv2+
URL:            http://gentrans.sourceforge.net/
Source0:        http://downloads.sourceforge.net/gentrans/%{name}-%{version}.tar.gz

# Patch python shebang to /usr/bin/python2
Patch0:         gst-entrans-python_shebang.patch
Patch1:         gst-entrans-enplayer_python_shebang.patch

BuildRequires:  gstreamer1.0-devel libgstreamer1.0-gir-devel
BuildRequires:  gst-plugins1.0-devel gst-plugins1.0-gir-devel
BuildRequires:  libalsa-devel
# For autoreconf
BuildRequires:  gettext-tools libasprintf-devel libtool
Requires:       gstreamer1.0 gstreamer1.0-utils libgstreamer1.0-gir
Requires:       gstreamer1-plugins-entrans = %{version}-%{release}
Requires:       python3-module-gst1.0
Source44: import.info

%description
GEntrans is a software package providing a collection of plug-ins and tools 
for the GStreamer multimedia framework specifically geared towards transcoding 
and recording purposes.

GStreamer allows for easy multimedia processing and creation of multimedia 
applications, as e.g. demonstrated by a number of players and some other 
applications already built on it. The purpose here is to concentrate on using 
the framework for transcoding purposes.


%package -n gstreamer1-plugins-entrans
Group: Sound
Summary:        GStreamer plug-ins from GEntrans
Obsoletes:      gstreamer-plugins-entrans < 0.10.4-4

%description -n gstreamer1-plugins-entrans
GEntrans is a software package providing a collection of plug-ins and tools 
for the GStreamer multimedia framework specifically geared towards transcoding 
and recording purposes.

This package provides several GStreamer plugins from GEntrans.


%package -n gstreamer1-plugins-entrans-docs
Group: Documentation
Summary:        Documentation for GStreamer plug-ins from GEntrans
BuildArch:      noarch
BuildRequires:  gtk-doc gtk-doc-mkpdf
Obsoletes:      gstreamer-plugins-entrans-docs < 0.10.4-4

%description -n gstreamer1-plugins-entrans-docs
GEntrans is a software package providing a collection of plug-ins and tools 
for the GStreamer multimedia framework specifically geared towards transcoding 
and recording purposes.

This package provides documentation for several GStreamer plugins from GEntrans.


%prep
%setup -q
%patch0 -p1 -b .python_shebang
%patch1 -p1 -b .python_shebang


%build
# Add aarch64 support to build
autoreconf -f -i
%configure --enable-debug --disable-static --enable-gtk-doc
%make_build


%check
make check


%install
make install DESTDIR=$RPM_BUILD_ROOT

# These files shouldn't be in the RPM
rm -f $RPM_BUILD_ROOT%{_libdir}/gstreamer-%{gstversion}/*.la
rm -f $RPM_BUILD_ROOT%{_libdir}/gstreamer-%{gstversion}/*.a

# Symlink the old executable name for compatibility
ln -s entrans-1.0 $RPM_BUILD_ROOT%{_bindir}/entrans
ln -s enplayer-1.0 $RPM_BUILD_ROOT%{_bindir}/enplayer



%files
%doc AUTHORS COPYING
%doc docs/manual/html/
%{_bindir}/entrans
%{_bindir}/entrans-1.0
%{_bindir}/enplayer
%{_bindir}/enplayer-1.0
%doc %{_mandir}/man1/entrans-*
%doc %{_mandir}/man1/enplayer-*


%files -n gstreamer1-plugins-entrans
%doc COPYING
%{_libdir}/gstreamer-%{gstversion}/libgstentransalsa.so
%{_libdir}/gstreamer-%{gstversion}/libgstentransavidemux.so
%{_libdir}/gstreamer-%{gstversion}/libgstentransentrans.so
%{_libdir}/gstreamer-%{gstversion}/libgstentransmencoder.so
%{_libdir}/gstreamer-%{gstversion}/libgstentranstranscode.so
%{_libdir}/gstreamer-%{gstversion}/libgstentransvirtualdub.so
%{_libdir}/gstreamer-%{gstversion}/libgstentransyuv4mpeg.so

%files -n gstreamer1-plugins-entrans-docs
%doc COPYING
%doc %{_datadir}/gtk-doc/html/%{name}-plugins-%{gstversion}/


%changelog
