BuildRequires: docbook-style-xsl
# BEGIN SourceDeps(oneline):
BuildRequires: gcc-c++ libgio-devel
# END SourceDeps(oneline)
# see https://bugzilla.altlinux.org/show_bug.cgi?id=10382
%define _localstatedir %{_var}
# %%version is ahead of its definition. Predefining for rpm 4.0 compatibility.
%define version 3.24.3
%define url_ver        %(echo %{version}|cut -d. -f1,2)
%global __provides_exclude_from %{_datadir}/gnome/help/.*
%global __requires_exclude_from %{_datadir}/gnome/help/.*

Summary:	Documentation of C++ wrappers for GLib/GTK+
Name:		gtkmm-documentation
Version:	3.24.3
Release:	alt1_1
License:	GFDL
Group:		Documentation
Url:		https://developer.gnome.org/
Source0:	https://download.gnome.org/sources/%{name}/%{url_ver}/%{name}-%{version}.tar.xz
BuildArch:	noarch
BuildRequires:	librarian
BuildRequires:	gnome-doc-utils
BuildRequires:	meson
BuildRequires:	perl
BuildRequires:	pkgconfig(giomm-2.4) >= 2.36.0
BuildRequires:	pkgconfig(gtkmm-3.0) >= 3.10.0
BuildRequires:	itstool
Source44: import.info

%description
GLib is a low-level general-purpose library used mainly by GTK+/GNOME
applications, but is useful for other programs as well. glibmm is the C++
wrapper for GLib.

Gtkmm is a C++ interface for the popular GUI library GTK+. It provides a
convenient interface for C++ programmers to create graphical user interfaces
with GTK+'s flexible OO framework. Highlights include type safe callbacks,
widgets extensible using inheritance and over 180 classes that can be freely
combined to quickly create complex user interfaces.

This package contains tutorial, FAQ, as well as examples for the above
components.

%prep
%setup -q

%build
%meson
%meson_build

%install
%meson_install

%find_lang %{name} --with-gnome --all-name --with-gnome

%files -f %{name}.lang
%doc NEWS README.md AUTHORS
%{_datadir}/doc/gtkmm-3.0/


%changelog
