Group: Development/Other
# BEGIN SourceDeps(oneline):
BuildRequires(pre): rpm-build-perl
BuildRequires: /usr/bin/dot perl(Parse/Yapp/Driver.pm) perl(Pod/Simple/HTML.pm) perl(Pod/Simple/HTMLBatch.pm) perl(Switch.pm) perl(Term/ReadLine.pm) perl(threads.pm) perl(threads/shared.pm) perl-podlators
# END SourceDeps(oneline)
%add_findreq_skiplist %perl_vendor_privlib/HCT*
# see https://bugzilla.altlinux.org/show_bug.cgi?id=10382
%define _localstatedir %{_var}
Name:           hct
Version:        0.7.60
Release:        alt2_35
Summary:        A HDL complexity tool

License:        GPLv3 and LGPLv3
URL:            http://hct.sourceforge.net/
Source0:        http://downloads.sourceforge.net/hct/hct-%{version}.tar.gz
Source1:        Makefile.PL
Patch0:         hct-set-env-hcthome.patch
Patch1:         hct-set-hct-path-for-moved-lang.patch 

BuildArch:      noarch

BuildRequires:  dos2unix
BuildRequires:  rpm-build-perl
BuildRequires:  perl(ExtUtils/MakeMaker.pm)


Source44: import.info

%description 
The goal of the HCT is to generate scores that represent
the complexity of the constituent modules of large 
integrated circuit design projects a.. i.e. SOCs. The design's 
complexity scores are useful to verification
teams so as to efficiently focus resources based on the dynamic
complexity profile of a design. The scores are a useful tool to guide
HDL designer's re-factoring efforts.

%prep
%setup -q -n hct-%{version}
%patch0 -p1 -b .fix
%patch1 -p1 -b .hct

sed -e "s|PERL_VENDORLIB|'%{perl_vendor_privlib}'|" hct.pl > hct.ex
chmod +x hct.ex
touch -r hct.pl hct.ex
mv hct.ex hct

cp lang/hdl/vhdl/parser.pm parser.ex
dos2unix parser.ex
touch -r lang/hdl/vhdl/parser.pm parser.ex
mv parser.ex lang/hdl/vhdl/parser.pm

find . -depth \( -name 'config*'   -o  \
                 -name 'windows'   -o  \
                 -name 'Misc'      -o  \
                 -name 'Pod'       -o  \
                 -name '.svn'      -o  \
                 -name '*.svn'         \) \
  -exec rm -rf -- '{}' +

find . -depth \( -name 'Makefile*' -o   \
                 -name '*sh'       -o  \
                 -name '*.output'  -o  \
                 -name '*.yp'      -o  \
                 -name '*.y'       -o  \
                 -name '*.l'       -o  \
                 -name '*.hct'     -o  \
                 -name '.*pm'      -o  \
                 -name '\.\_*'     -o  \
                 -name '\#*'           \) \
  -exec rm -f -- '{}' +

rm -f src/perllib/HCT/Lang/YappParserTracer.pm

chmod -x src/perllib/HCT.pm
chmod -x lang/hdl/verilog.pm
chmod -x lang/README
chmod -x lang/hdl/cdl/lexer.pm
chmod -x lang/hdl/cdl.pm
chmod -x lang/hdl/vhdl/parser.pm
chmod -x lang/hdl/verilog/lexer.pm

mkdir lib
mv src/perllib/* lib/
mv lang lib/HCT
rm -rf src
cp %{SOURCE1} %{_builddir}/%{name}-%{version}


%build
/usr/bin/perl Makefile.PL INSTALLDIRS=vendor
make %{?_smp_mflags}

%check
%{__make} test TEST_VERBOSE=1

%install
make pure_install DESTDIR=%{buildroot}
find %{buildroot} -type f -name .packlist -exec rm -f {} ';'
find %{buildroot} -depth -type d -exec rmdir {} 2>/dev/null ';'

rm -f %{buildroot}/%{perl_vendor_privlib}/hct.pl

# %{_fixperms} %{buildroot}/*

%files
%doc COPYING COPYING.LESSER README
%{perl_vendor_privlib}/*
%{_bindir}/hct

%changelog
