Group: Sound
# BEGIN SourceDeps(oneline):
BuildRequires: /usr/bin/desktop-file-install ladspa_sdk libreadline-devel
# END SourceDeps(oneline)
# see https://bugzilla.altlinux.org/show_bug.cgi?id=10382
%define _localstatedir %{_var}
%global       srcname0 hexter

Summary:      DSSI software synthesizer plugin emulating DX7
Name:         hexter-dssi
Version:      1.1.0
Release:      alt2_4
URL:          http://smbolton.com/hexter.html
Source0:      https://github.com/smbolton/%{srcname0}/archive/version_%{version}/%{srcname0}-version_%{version}.tar.gz
Source1:      hexter.desktop
Source2:      hexter.png
Patch0:       Fixed-Segfault-on-startup.patch
License:      GPLv2+

BuildRequires: gcc
BuildRequires: libalsa-devel
BuildRequires: desktop-file-utils
BuildRequires: dssi-devel
BuildRequires: gtk-builder-convert gtk-demo libgail-devel libgtk+2-devel
BuildRequires: liblo-devel
BuildRequires: libncurses++-devel libncurses-devel libncursesw-devel libtic-devel libtinfo-devel
BuildRequires: chrpath
BuildRequires: automake
BuildRequires: autoconf
BuildRequires: libtool
Requires:      dssi
Source44: import.info

%description
hexter is a software synthesizer that models the sound generation of a Yamaha
DX7 synthesizer. It can easily load most DX7 patch bank files, accept patch
editing commands via MIDI sys-ex messages (ALSA systems only), and recreate the
sound of the DX7 with greater accuracy than any previous open-source emulation
(that the author is aware of....)

hexter operates as a plugin for the Disposable Soft Synth Interface (DSSI).
DSSI is a plugin API for software instruments (soft synths) with user
interfaces, permitting them to be hosted in-process by audio applications.

%prep
%setup -q -n %{srcname0}-version_%{version}
%patch0 -p1

%build
export LDFLAGS="-lm"
./autogen.sh
%configure --with-gnu-ld
%make_build
(cd extra; gcc $CFLAGS -o tx_edit tx_edit.c -lcurses -lasound -lm)

%install
make install DESTDIR=$RPM_BUILD_ROOT INSTALL="install -p"
mkdir -p $RPM_BUILD_ROOT%{_bindir}
ln -s jack-dssi-host $RPM_BUILD_ROOT%{_bindir}/hexter
install -m 755 extra/tx_edit $RPM_BUILD_ROOT%{_bindir}/tx_edit

mkdir -p $RPM_BUILD_ROOT%{_datadir}/applications
desktop-file-install                              \
  --dir ${RPM_BUILD_ROOT}%{_datadir}/applications \
  %{SOURCE1}

mkdir -p $RPM_BUILD_ROOT%{_datadir}/icons/hicolor/36x36/apps
install -pm 644 %{SOURCE2} $RPM_BUILD_ROOT%{_datadir}/icons/hicolor/36x36/apps/hexter.png

%files
%doc AUTHORS ChangeLog COPYING README.rst TODO
%{_bindir}/hexter
%{_bindir}/tx_edit
%{_datadir}/hexter/
%{_datadir}/applications/hexter.desktop
%{_datadir}/icons/hicolor/36x36/apps/hexter.png
%{_libdir}/dssi/*
%exclude %{_libdir}/dssi/hexter.la

%changelog
