Group: File tools
# see https://bugzilla.altlinux.org/show_bug.cgi?id=10382
%define _localstatedir %{_var}
Summary: Tools for reading Macintosh HFS+ volumes
Name: hfsplusutils
Version: 1.0.4
Release: alt1_31

License: GPLv2+
URL: ftp://ftp.penguinppc.org/users/hasi/hfsplus_1.0.4.src.tar.bz2
Source0: ftp://ftp.penguinppc.org/users/hasi/hfsplus_%{version}.src.tar.bz2
Patch0: hfsplusutils-1.0.4-nullisnotachar.patch
Patch1: hfsplusutils-1.0.4-errno.patch
Patch2: hfsplusutils-1.0.4-includes.patch
Patch3: hfsplusutils-1.0.4-gcc4.patch
Patch4: hfsplusutils-1.0.4-memset.patch
BuildRequires: automake, autoconf, libtool
Source44: import.info
%description
This package is a set of tools that allow access to HFS+ formatted
volumes. HFS+ is a modernized version of Apple Computers HFS
Filesystem.

%prep
%setup -q -n hfsplus-1.0.4

%patch0 -p1
%patch1 -p1
%patch2 -p1
%patch3 -p1
%patch4 -p1

sed -i -e 's/^CFLAGS\s/AM_CFLAGS /' {libhfsp/src,src}/Makefile.am

# Oh autocrap how we hate thee
autoreconf -i

%build
# FIXME: Package suffers from c11/inline issues
# Workaround by appending -std=gnu89 to CFLAGS
# Proper fix would be to fix the source-code
%configure --disable-shared --disable-dependency-tracking CFLAGS="${RPM_OPT_FLAGS} -std=gnu89"
%make_build

%install
make DESTDIR=$RPM_BUILD_ROOT SUBDIRS=src install
ln -sf hpfsck $RPM_BUILD_ROOT/%{_bindir}/fsck.hfsplus
# Remove zero-length doc file
rm -f mail/extents.diff
mkdir -p $RPM_BUILD_ROOT/%{_mandir}/man1
gzip -c < doc/man/hfsp.man > $RPM_BUILD_ROOT/%{_mandir}/man1/hfsp.1.gz
for a in hpcd hpcopy hpfsck hpls hpmkdir hpmount hppwd hprm hpumount fsck.hfsplus ; do
	ln -sf hfsp.1.gz $RPM_BUILD_ROOT/%{_mandir}/man1/$a.1.gz
done

%files
%{_bindir}/hpcd
%{_bindir}/hpcopy
%{_bindir}/hpfsck
%{_bindir}/fsck.hfsplus
%{_bindir}/hpls
%{_bindir}/hpmkdir
%{_bindir}/hpmount
%{_bindir}/hppwd
%{_bindir}/hprm
%{_bindir}/hpumount
%{_mandir}/man1/*
%doc doc/*.html
%doc mail
%doc AUTHORS NEWS README


%changelog
