Group: Other
# BEGIN SourceDeps(oneline):
BuildRequires(pre): rpm-macros-fedora-compat
BuildRequires: /usr/bin/desktop-file-validate rpm-build-python3
# END SourceDeps(oneline)
# see https://bugzilla.altlinux.org/show_bug.cgi?id=10382
%define _localstatedir %{_var}
# LuaJIT git snapshot
%global commit1 3f9389edc6cdf3f78a6896d550c236860aed62b2
%global shortcommit1 %(c=%{commit1}; echo ${c:0:7})

Name:           howl
Version:        0.6
Release:        alt2_29
Summary:        Lightweight editor with a keyboard-centric minimalistic UI

# For a breakdown of the licensing, see LICENSE.md
# Automatically converted from old format: MIT and Public Domain and BSD - review is highly recommended.
License:        LicenseRef-Callaway-MIT AND LicenseRef-Callaway-Public-Domain AND LicenseRef-Callaway-BSD
URL:            https://howl.io
Source0:        https://github.com/howl-editor/howl/releases/download/%{version}/%{name}-%{version}.tgz
# newer git snapshot for LuaJIT for aarch64 support
Source1:        https://github.com/LuaJIT/LuaJIT/archive/%{commit1}/LuaJIT-%{shortcommit1}.tar.gz

# Bundled LuaJIT-2.1.0-beta3 failed to compile with this arches
ExcludeArch:    ppc64le s390x
# https://fedoraproject.org/wiki/Changes/EncourageI686LeafRemoval
ExcludeArch:    %{ix86}

BuildRequires:  desktop-file-utils
BuildRequires:  gcc
BuildRequires:  libappstream-glib libappstream-glib-gir
BuildRequires:  pkgconfig(gtk+-3.0)

Obsoletes:      %{name}-data < 0.6-21

Requires:       icon-theme-hicolor

Requires:     fonts-otf-fontawesome

Provides:       bundled(luajit) = 2.1.0~beta3

# Filter out Python and Ruby requirements pulled in from examples
%global __requires_exclude_from ^%{_datadir}/howl/.*$

%global _description \
Howl is a general purpose editor that aims to be both lightweight and fully\
customizable. It's built on top of the very fast LuaJIT runtime, uses Gtk for\
its interface, and can be extended in either Lua or Moonscript. It's known to\
work on Linux, but should work on at least the *BSD's as well.
Source44: import.info

%description 
%{_description}

%prep
%setup -q -a1

%ifarch aarch64
rm -rf src/deps/LuaJIT-2.1.0-beta3
mv LuaJIT-%{commit1} src/deps/LuaJIT-2.1.0-beta3
%endif

%build
export HOST_CFLAGS="%{optflags}"
export HOST_LDFLAGS="%{build_ldflags}"
export TARGET_CFLAGS="%{optflags}"
export TARGET_LDFLAGS="%{build_ldflags}"
%make_build -C src

%install
%makeinstall_std -C src PREFIX=%{_prefix}
# https://docs.fedoraproject.org/en-US/packaging-guidelines/#_avoid_bundling_of_fonts_in_other_packages
# We can install it in *Requires*
rm -r       %{buildroot}%{_datadir}/howl/fonts
# https://github.com/howl-editor/howl/pull/502
mv          %{buildroot}%{_datadir}/appdata %{buildroot}%{_metainfodir}
# https://github.com/howl-editor/howl/issues/501#issuecomment-484565885
find        %{buildroot}%{_datadir}/howl/bundles/python/misc/ -type f -name "*.py" -exec sed -e 's@/usr/bin/env python@/usr/bin/python3@g' -i "{}" \;
find        %{buildroot}%{_datadir}/howl/bundles/ruby/misc/ -type f -name "*.rb" -exec sed -e 's@/usr/bin/env ruby@/usr/bin/ruby@g' -i "{}" \;

%check
appstream-util validate-relax --nonet %{buildroot}%{_metainfodir}/howl.appdata.xml
desktop-file-validate %{buildroot}%{_datadir}/applications/howl.desktop

%files
%doc README.md Changelog.md
%doc --no-dereference LICENSE.md
%{_bindir}/howl
%{_bindir}/howl-spec
%{_datadir}/applications/howl.desktop
%{_datadir}/howl/
%{_datadir}/icons/hicolor/scalable/apps/howl.svg
%{_metainfodir}/howl.appdata.xml

%changelog
