# see https://bugzilla.altlinux.org/show_bug.cgi?id=10382
%define _localstatedir %{_var}
Name:		httpfs2
Version:	0.1.5
Release:	alt1_8
Summary:	FUSE filesystem for mounting files from HTTP servers
License:	GPLv2+
Group:		Networking/Remote access
URL:		https://httpfs.sourceforge.net/
Source0:	https://sourceforge.net/projects/httpfs/files/%{name}/%{name}-%{version}.tar.gz
Patch0:		httpfs2-0.1.5-mga-add_makeinstall_rule.patch
BuildRequires:	pkgconfig(fuse)
BuildRequires:	pkgconfig(gnutls)
BuildRequires:	asciidoc asciidoc-a2x asciidoc-latex
# for a2x
BuildRequires:	dblatex
BuildRequires:	fop
BuildRequires:	w3m
BuildRequires:	xsltproc

Requires:	fuse
Source44: import.info

%description
httpfs2 is a FUSE based filesystem for mounting HTTP or HTTPS URLS as files
in the filesystem. There is no notion of listable directories in HTTP so
only a single URL can be mounted. The server must be able to send byte ranges.


%prep
%setup -q
%patch0 -p1


# fix rpmlint warning: wrong-file-end-of-line-encoding
sed -i 's/\r$//' httpfs2.1.txt

%build
%make_build

%install
%makeinstall_std

%files
%doc httpfs2.1.txt
%{_bindir}/%{name}
%{_bindir}/%{name}-mt
%{_bindir}/%{name}-ssl
%{_bindir}/%{name}-ssl-mt
%{_mandir}/man1/%{name}*.1*


%changelog
