# see https://bugzilla.altlinux.org/show_bug.cgi?id=10382
%define _localstatedir %{_var}
Name:		hydrogen-drumkits
Version:	0.9.3
Release:	alt1_8
Summary:	Additional DrumKits for Hydrogen
License:	GPLv2+ and GPLv3 and Green OpenMusic
Group:		Sound
URL:		http://www.hydrogen-music.org
Source0:	https://downloads.sourceforge.net/hydrogen/Classic-626.h2drumkit
Source1:	https://downloads.sourceforge.net/hydrogen/Classic-808.h2drumkit
Source2:	https://downloads.sourceforge.net/hydrogen/ColomboAcousticDrumkit.h2drumkit
Source3:	https://downloads.sourceforge.net/hydrogen/ElectricEmpireKit.h2drumkit
Source4:	https://downloads.sourceforge.net/hydrogen/HardElectro1.h2drumkit
Source5:	https://downloads.sourceforge.net/hydrogen/K-27_Trash_Kit.h2drumkit
Source6:	https://downloads.sourceforge.net/hydrogen/Millo-Drums_v.1.h2drumkit
Source7:	https://downloads.sourceforge.net/hydrogen/Millo_MultiLayered2.h2drumkit
Source8:	https://downloads.sourceforge.net/hydrogen/Millo_MultiLayered3.h2drumkit
Source9:	https://downloads.sourceforge.net/hydrogen/VariBreaks.h2drumkit

# URL: https://pkgs.fedoraproject.org/repo/pkgs/hydrogen-drumkits/asma_davul.tar.gz/88196a71b20a656e97e70071569dd82f/
Source10:	https://www.ardaeden.net/asma_davul/files/asma_davul.tar.gz

# get-kits downloads the drumkits above from the urls in the drumkit_urls.txt file for convenience
Source11:	drumkit_urls.txt
Source12:	get-kits

BuildArch: noarch

Requires: hydrogen >= 0.9.3
Source44: import.info

%description
A collection of additional drumkits for the 
Hydrogen advanced drum machine for GNU/Linux.

%prep
%setup -q -c -n %{name} -a 0 -a 1 -a 2 -a 3 -a 4 -a 5 -a 6 -a 7 -a 8 -a 9 -a 10
# Rename the doc files to avoid confusion:
for licencedir in Classic-626 Classic-808 \
    ElectricEmpireKit HardElectro1 Millo-Drums_v.1 \
    Millo_MultiLayered2 Millo_MultiLayered3 ; do
  mv $licencedir/LICENCE LICENCE.$licencedir
done

mv asma_davul/GPLv.3 license.asma_davul

mv ColomboAcousticDrumkit/COPYING COPYING.ColomboAcousticDrumkit
mv ColomboAcousticDrumkit/README README.ColomboAcousticDrumkit
iconv -f iso-8859-1 -t utf8 README.ColomboAcousticDrumkit -o README.tmp
touch -r README.ColomboAcousticDrumkit README.tmp
mv -f README.tmp README.ColomboAcousticDrumkit

mv K-27_Trash_Kit/license.html license.K-27_Trash_Kit.html

# The demo songs need to be separated from drumkits:
find . -name *.h2song -exec mv {} . \;

%build
echo "Nothing to build."

%install

# These directories are owned by hydrogen:
install -dm 0755 %{buildroot}%{_datadir}/hydrogen/data/drumkits
install -dm 0755 %{buildroot}%{_datadir}/hydrogen/data/demo_songs

# Now copy everything into the buildroot
for drumkitdir in asma_davul Classic-626 Classic-808 \
ColomboAcousticDrumkit ElectricEmpireKit \
HardElectro1 K-27_Trash_Kit \
Millo-Drums_v.1 Millo_MultiLayered2 \
Millo_MultiLayered3 VariBreaks ; do
  cp -a $drumkitdir  %{buildroot}%{_datadir}/hydrogen/data/drumkits
done

find . -name *.h2song -exec cp -a {} %{buildroot}%{_datadir}/hydrogen/data/demo_songs \;

%files
%doc COPYING.* LICENCE.* license.* README.*
%{_datadir}/hydrogen/data/demo_songs/*
%{_datadir}/hydrogen/data/drumkits/* 


%changelog
