# see https://bugzilla.altlinux.org/show_bug.cgi?id=10382
%define _localstatedir %{_var}
%define  verdate  20160503
%define  srcname  %{verdate}_a

# Upstream version
%define major        0
%define libname      libsofa%{major}
%define libname_virt libsofa
%define develname    libsofa-devel

Name:           iausofa-c
Version:        %{verdate}a
Release:        alt1_5
Summary:        Standards of fundamental astronomy
Group:          Sciences/Astronomy
License:        SOFA
URL:            https://www.iausofa.org/
Source0:        https://www.iausofa.org/2012_0301_C/sofa_c-%{srcname}.tar.gz
Patch0:         iausofa-c-makefile.patch
Source44: import.info

%description
SOFA operates under the auspices of the International Astronomical
Union (IAU) to provide algorithms and software for use in astronomical
computing. The initiative is managed by an international panel, the
SOFA Board, appointed through IAU Division A. The Board obtains the
latest IAU-approved models and theories from the fundamental-astronomy
community, implements them as computer code and checks them for
accuracy. SOFA works closely with all the Commissions of the Division
and with the International Earth Rotation and Reference Systems
Service (IERS).

%package -n %{develname}
Summary:        Headers for developing programs that will use %{name}
Group:          Sciences/Astronomy
Requires:       %{libname_virt} = %{version}-%{release}
Provides:       %{name}-devel = %{version}-%{release}

%description -n %{develname}
These are the header files and libraries needed to develop a %{name} 
application.

%package -n %{libname}
Summary:        Standards of fundamental astronomy
Group:          Sciences/Astronomy
Provides:       %{name} = %{version}-%{release}
Provides:       %{libname_virt} = %{version}-%{release}

%description -n %{libname}
SOFA operates under the auspices of the International Astronomical
Union (IAU) to provide algorithms and software for use in astronomical
computing. The initiative is managed by an international panel, the
SOFA Board, appointed through IAU Division A. The Board obtains the
latest IAU-approved models and theories from the fundamental-astronomy
community, implements them as computer code and checks them for
accuracy. SOFA works closely with all the Commissions of the Division
and with the International Earth Rotation and Reference Systems
Service (IERS)

%prep
%setup -q -n sofa
%patch0 -p1


%build
cd %{srcname}/c/src
%make_build INSTALL_DIR=%{buildroot}%{_prefix} \
            SOFA_LIB_DIR=%{buildroot}%{_libdir} \
            CFLAGF="-c -fPIC %{optflags}" \
            CFLAGL="%{optflags}"


%install
cd %{srcname}/c/src

install -D -m644 *.h -t %{buildroot}%{_includedir}
install -D libsofa_c.so.0.0 -t %{buildroot}%{_libdir}

pushd %{buildroot}%{_libdir}
ln -s libsofa_c.so.0.0 libsofa_c.so.0
ln -s libsofa_c.so.0 libsofa_c.so
popd

%files -n %{libname}
%{_libdir}/libsofa_c.so.%{major}
%{_libdir}/libsofa_c.so.%{major}.*

%files -n %{develname}
%{_libdir}/libsofa_c.so
%{_includedir}/*


%changelog
