# BEGIN SourceDeps(oneline):
BuildRequires: gcc-c++ python-devel
# END SourceDeps(oneline)
# see https://bugzilla.altlinux.org/show_bug.cgi?id=10382
%define _localstatedir %{_var}
%global require_ibus_version 1.3.99

Name:		ibus-gucharmap
Version:	1.4.0
Release:	alt1_15
Summary:	Unicode input engine (using Gucharmap) for IBus platform

License:	GPLv2+
Group:		System/Libraries
URL:		http://github.com/ueno/ibus-charmap/
Source0:	https://github.com/ueno/ibus-charmap/archive/%{name}-%{version}.tar.gz

BuildRequires:	vala
BuildRequires:	libgucharmap-devel libgucharmap-gir-devel
BuildRequires:	libsqlite3-devel
BuildRequires:	libibus-devel libibus-gir-devel
# for regenerating configure script
BuildRequires:	gnome-common gettext-tools libasprintf-devel
Requires:	ibus >= %{require_ibus_version}

%description
A Unicode input engine (using Gucharmap) for IBus, which supports
character-map view and searching by Unicode names with easy key
navigation.

%prep
%setup -q -n %{name}-%{version}
NOCONFIGURE=yes ./autogen.sh


%build
%configure
%make_build


%install
make install DESTDIR=$RPM_BUILD_ROOT INSTALL="install -p"

%find_lang %{name}


%files -f %{name}.lang
%doc COPYING README
%{_libexecdir}/ibus-engine-gucharmap
%{_libexecdir}/ibus-setup-gucharmap
%{_datadir}/ibus/component/gucharmap.xml
%{_datadir}/ibus-gucharmap/unicodenames.sqlite3
%{_datadir}/ibus-gucharmap/setup/ibus-gucharmap-preferences.ui

%changelog
