Group: System/Libraries
# BEGIN SourceDeps(oneline):
BuildRequires(pre): rpm-macros-fedora-compat
BuildRequires: /usr/bin/desktop-file-validate gcc-c++ glib2-devel
# END SourceDeps(oneline)
# see https://bugzilla.altlinux.org/show_bug.cgi?id=10382
%define _localstatedir %{_var}
BuildRequires: /usr/bin/git
%define autorelease 2

Name:       ibus-input-pad
Version:    1.5.0
Release:    alt1_%autorelease
Summary:    Input Pad for IBus
License:    GPL-2.0-or-later
URL:        https://github.com/fujiwarat/input-pad/wiki
Source0:    https://github.com/fujiwarat/%{name}/releases/download/%{version}/%{name}-%{version}.tar.gz
# Patch0:     %%{name}-HEAD.patch

BuildRequires:  desktop-file-utils
BuildRequires:  gettext-tools libasprintf-devel
BuildRequires:  git
BuildRequires:  gtk3-demo libgail3-devel libgtk+3 libgtk+3-devel libgtk+3-gir-devel
BuildRequires:  libappstream-glib libappstream-glib-gir
BuildRequires:  libtool
BuildRequires:  libibus-devel libibus-gir-devel
BuildRequires:  input-pad-devel
Requires:       ibus python3-module-ibus-overrides
Source44: import.info

%description
The input pad engine for IBus platform.

%prep
%setup -q
git init -q
git config user.name "rpmbuild"
git config user.email "<rpmbuild>"
git config gc.auto 0
git add --force .
git commit -q --allow-empty -a --author "rpmbuild <rpmbuild>" -m "%{NAME}-%{VERSION} base"


%build
#autoreconf -v -f -i
%configure \
    --disable-static
%make_build

%install
%makeinstall_std

# Register as an AppStream component to be visible in the software center
#
# NOTE: It would be *awesome* if this file was maintained by the upstream
# project, translated and installed into the right place during `make install`.
#
# See http://www.freedesktop.org/software/appstream/docs/ for more details.
#
mkdir -p $RPM_BUILD_ROOT%{_metainfodir}
cat > $RPM_BUILD_ROOT%{_metainfodir}/input-pad.appdata.xml <<EOF
<?xml version="1.0" encoding="UTF-8"?>
<component type="inputmethod">
  <id>input-pad.xml</id>
  <metadata_license>CC0-1.0</metadata_license>
  <name>Input Pad</name>
  <summary>Input Pad input method</summary>
  <description>
    <p>
      The Input Pad input method is designed for entering special symbols.
    </p>
    <p>
      Input methods are typing systems allowing users to input complex languages.
      They are necessary because these contain too many characters to simply be laid
      out on a traditional keyboard.
    </p>
  </description>
  <url type="homepage">https://github.com/fujiwarat/input-pad/wiki</url>
  <url type="bugtracker">https://github.com/fujiwarat/ibus-input-pad/issues</url>
  <url type="help">https://github.com/fujiwarat/input-pad/wiki/Installation</url>
  <screenshots>
    <screenshot type="default">
      <caption>Input Pad for IBus</caption>
      <image type="source" width="1600" height="900">https://raw.githubusercontent.com/fujiwarat/input-pad/master/web/images/screenshot1.png</image>
    </screenshot>
  </screenshots>
  <update_contact>fujiwara_AT_redhat.com</update_contact>
</component>
EOF

%find_lang %{name}

%check
desktop-file-validate \
    $RPM_BUILD_ROOT%{_datadir}/applications/ibus-setup-input-pad.desktop
appstream-util validate-relax --nonet \
    $RPM_BUILD_ROOT%{_metainfodir}/*.appdata.xml

%files -f %{name}.lang
%doc AUTHORS README
%doc --no-dereference COPYING
%{_libexecdir}/ibus-engine-input-pad
%{_libexecdir}/ibus-setup-input-pad
%{_metainfodir}/*.appdata.xml
%{_datadir}/applications/ibus-setup-input-pad.desktop
%{_datadir}/ibus/component/*

%changelog
