%filter_from_requires /^python3.tabsqlitedb./d
Group: System/Libraries
# BEGIN SourceDeps(oneline):
BuildRequires(pre): rpm-build-python3
BuildRequires: /usr/bin/desktop-file-validate
# END SourceDeps(oneline)
%define fedora 34
# see https://bugzilla.altlinux.org/show_bug.cgi?id=10382
%define _localstatedir %{_var}
Name:       ibus-table
Version:    1.14.1
Release:    alt1_1
Summary:    The Table engine for IBus platform
License:    LGPLv2+
URL:        http://code.google.com/p/ibus/
Source0:    https://github.com/mike-fabian/ibus-table/releases/download/%{version}/%{name}-%{version}.tar.gz
Requires:       ibus python3-module-ibus-overrides
%{?__python3:Requires: %{__python3}}
# To play a sound on error:
Requires: python3-module-simpleaudio
BuildRequires:  gcc
BuildRequires:  libibus-devel libibus-gir-devel
BuildRequires:  python3-devel
# for the unit tests
%if 0%{?fedora}
BuildRequires:  appstream libappstream
%endif
BuildRequires:  docbook-utils
BuildRequires:  libappstream-glib
BuildRequires:  desktop-file-utils
BuildRequires:  python3-module-pygobject3
BuildRequires:  python3-module-pygobject3 python3-module-pygobject3-pygtkcompat
BuildRequires:  dbus-tools-gui
BuildRequires:  xorg-xvfb xvfb-run
BuildRequires:  ibus-table-chinese-wubi-jidian
BuildRequires:  ibus-table-chinese-cangjie
BuildRequires:  ibus-table-chinese-stroke5
BuildRequires:  ibus-table-code
BuildRequires:  ibus-table-latin
BuildRequires:  ibus-table-translit
BuildRequires:  ibus-table-tv

Obsoletes:   ibus-table-additional < 1.2.0.20100111-5

BuildArch:  noarch
Source44: import.info

%description
The Table engine for IBus platform.

%package -n %{name}-devel
Group: Development/C
Summary:        Development files for %{name}
Requires:       %{name} = %{version}-%{release}, pkgconfig

%description -n %{name}-devel
Development files for %{name}.

%package tests
Group: System/Libraries
Summary:        Tests for the %{name} package
Requires:       %{name} = %{version}-%{release}
AutoReqProv: no

%description tests
The %{name}-tests package contains tests that can be used to verify
the functionality of the installed %{name} package.

%prep
%setup -q

sed -i '1s,#!/usr/bin/python,#!/usr/bin/python3,' engine/chinese_variants.py


%build
export PYTHON=%{__python3}
%configure --disable-static --disable-additional --enable-installed-tests
%make_build

%install
export PYTHON=%{__python3}
%makeinstall_std NO_INDEX=true pkgconfigdir=%{_datadir}/pkgconfig
#py_byte_compile /usr/bin/python3 %{buildroot}/usr/share/ibus-table/engine
#py_byte_compile /usr/bin/python3 %{buildroot}/usr/share/ibus-table/setup

%find_lang %{name}

%check
%if 0
%if 0
appstreamcli validate --pedantic --explain --no-net %{buildroot}/%{_datadir}/metainfo/*.appdata.xml
%endif
appstream-util validate-relax --nonet %{buildroot}/%{_datadir}/metainfo/*.appdata.xml
desktop-file-validate \
    $RPM_BUILD_ROOT%{_datadir}/applications/ibus-setup-table.desktop
pushd engine
# run doctests
    python3 table.py
    python3 it_util.py
popd
mkdir -p /tmp/glib-2.0/schemas/
cp org.freedesktop.ibus.engine.table.gschema.xml \
   /tmp/glib-2.0/schemas/org.freedesktop.ibus.engine.table.gschema.xml
glib-compile-schemas /tmp/glib-2.0/schemas #&>/dev/null || :
export XDG_DATA_DIRS=/tmp
eval $(dbus-launch --sh-syntax)
dconf dump /
dconf write /org/freedesktop/ibus/engine/table/wubi-jidian/chinesemode 1
dconf write /org/freedesktop/ibus/engine/table/wubi-jidian/spacekeybehavior false
dconf dump /
export DISPLAY=:1
Xvfb $DISPLAY -screen 0 1024x768x16 &
# A window manager and and ibus-daemon are needed to run the GUI
# test tests/test_gtk.py, for example i3 can be used.
#
# To debug what is going on if there is a problem with the GUI test
# add BuildRequires: x11vnc and start a vnc server:
#
#     x11vnc -display $DISPLAY -unixsock /tmp/mysock -bg -nopw -listen localhost -xkb
#
# Then one can view what is going on outside of the chroot with vncviewer:
#
#     vncviewer /var/lib/mock/fedora-32-x86_64/root/tmp/mysock
#
# The GUI test will be skipped if XDG_SESSION_TYPE is not x11 or wayland.
#
#ibus-daemon -drx
#touch /tmp/i3config
#i3 -c /tmp/i3config &
#export XDG_SESSION_TYPE=x11

make check && rc=0 || rc=1
cat tests/*.log
if [ $rc != 0 ] ; then
    exit $rc
fi
%endif

%files -f %{name}.lang
%doc AUTHORS COPYING README
%{_datadir}/%{name}
%{_datadir}/metainfo/*.appdata.xml
%{_datadir}/ibus/component/table.xml
%{_datadir}/applications/ibus-setup-table.desktop
%{_datadir}/glib-2.0/schemas/org.freedesktop.ibus.engine.table.gschema.xml
%{_bindir}/%{name}-createdb
%{_libexecdir}/ibus-engine-table
%{_libexecdir}/ibus-setup-table
%{_mandir}/man1/*

%files devel
%{_datadir}/pkgconfig/%{name}.pc

%files tests
%dir %{_libexecdir}/installed-tests
%{_libexecdir}/installed-tests/%{name}
%dir %{_datadir}/installed-tests
%{_datadir}/installed-tests/%{name}

%changelog
