Group: Graphical desktop/Other
%define oldname humanity-icon-theme
# see https://bugzilla.altlinux.org/show_bug.cgi?id=10382
%define _localstatedir %{_var}
Name:           icon-theme-humanity
Version:        0.6.15
Release:        alt1_10
Summary:        Humanity icon theme

License:        GPLv2
URL:            https://launchpad.net/humanity/
Source0:        %{oldname}-%{version}-without-logos.tar.xz
# Humanity icon theme contains copyrighted Ubuntu logo icons. Therefore we use
# this script to delete these files and remove any reference to the Ubuntu
# trademark before shipping it
Source1:        %{oldname}-generate-tarball.sh

BuildRequires:  icon-naming-utils
BuildRequires:  python3-module-scour
Requires:       icon-theme-adwaita
Requires:       icon-theme-hicolor
BuildArch:      noarch
Source44: import.info

%description
Humanity and Humanity Dark are nice and well polished icon themes for the GNOME
desktop.


%prep
%setup -n %{oldname}-%{version} -q



%build
for i in $(find . -type f -name "*.svg"); do
    scour -i $i -o $i.tmp --disable-style-to-xml && mv $i.tmp $i
done

for d in Humanity/*/ Humanity-Dark/*/; do
    pushd "$d"
    for i in */; do
/usr/lib/icon-name-mapping -c $i
    done
    popd
done


%install
install -dpm 0755 $RPM_BUILD_ROOT%{_datadir}/icons/
cp -a Humanity/ $RPM_BUILD_ROOT%{_datadir}/icons/
cp -a Humanity-Dark/ $RPM_BUILD_ROOT%{_datadir}/icons/

# Remove documentation and license files in theme folders
rm $RPM_BUILD_ROOT%{_datadir}/icons/Humanity/{AUTHORS,CONTRIBUTORS,COPYING}
rm $RPM_BUILD_ROOT%{_datadir}/icons/Humanity-Dark/{AUTHORS,COPYING}
for rpm404_ghost in %{_datadir}/icons/Humanity/icon-theme.cache %{_datadir}/icons/Humanity-Dark/icon-theme.cache
do
    mkdir -p %buildroot`dirname "$rpm404_ghost"`
    touch %buildroot"$rpm404_ghost"
done



%files
%doc Humanity/AUTHORS
%doc Humanity/CONTRIBUTORS
%doc --no-dereference Humanity/COPYING
%{_datadir}/icons/Humanity/
%ghost %{_datadir}/icons/Humanity/icon-theme.cache
%{_datadir}/icons/Humanity-Dark/
%ghost %{_datadir}/icons/Humanity-Dark/icon-theme.cache


%changelog
