Group: Other
# BEGIN SourceDeps(oneline):
BuildRequires: swig
# END SourceDeps(oneline)
# see https://bugzilla.altlinux.org/show_bug.cgi?id=10382
%define _localstatedir %{_var}
Name:           ifm
Version:        5.1
Release:        alt1_28
Summary:        Interactive Fiction Mapper

License:        GPLv2+
URL:            http://www.sentex.net/~dchapes/ifm/
Source0:        http://www.ifarchive.org/if-archive/mapping-tools/ifm-%{version}.tar.gz
Source1:        ifm.vim
Source2:        ifm.sh
Patch1:         ifm-5.1-destdir.patch

BuildRequires:  gcc
BuildRequires:  rpm-build-perl
BuildRequires:  libtk tk
BuildRequires:  zlib-devel
BuildRequires:  automake
Source44: import.info

%description
IFM is a language and a program for keeping track of your progress through
an Interactive Fiction game.  You can record each room you visit and its
relation to other rooms, the initial locations of useful items you find, and
the tasks you need to perform in order to solve the game.


%prep
%setup -q
%patch1 -p1
install -pm 0644 %{SOURCE1} doc/.
install -pm 0644 %{SOURCE2} doc/.
sed -i -e 's,/usr/local/doc/ifm/html,%{_docdir}/%{name}-%{version}/ifm,' \
       -e 's,/usr/local/doc/ifm/ifm.pdf,%{_docdir}/%{name}-%{version}/ifm.pdf,' \
       doc/ifm.1

# Needed for ppc64, automake can't be run here
cp -f %{_datadir}/automake-*/config.* etc/


%build
%configure
%make_build


%install
make install DESTDIR=$RPM_BUILD_ROOT
rm -rf $RPM_BUILD_ROOT/%{_prefix}/doc
rm -f demos/Makefile*
rm -f doc/ifm/WARNINGS doc/ifm/images.* doc/ifm/*.pl



%files
%doc COPYING NEWS README THANKS
%doc demos/
%doc doc/advent?.scr doc/advent.cmd doc/gfdl.lyx doc/ifm.pdf doc/macros.tex doc/tkifm.txt doc/*.ifm doc/ifm.vim doc/ifm.sh
%doc doc/ifm/
%{_bindir}/*
%{_datadir}/ifm/
%{_libdir}/ifm/
%{_mandir}/man1/ifm.1*


%changelog
