Group: Other
# BEGIN SourceDeps(oneline):
BuildRequires: perl(Config.pm) perl(ExtUtils/Liblist.pm) perl(ExtUtils/MakeMaker.pm) perl(IO/File.pm) perl-devel
# END SourceDeps(oneline)
%define fedora 30
# see https://bugzilla.altlinux.org/show_bug.cgi?id=10382
%define _localstatedir %{_var}
%global commit 2431b455f46649d1b079d1e76a14a573cb4c9153
%global shortcommit %(c=%{commit}; echo ${c:0:7})

%global iipver 1.0

Name:           iipsrv
Version:        1.0.0
Release:        alt1_14.0
Summary:        Light-weight streaming for viewing and zooming of ultra high-resolution images

License:        GPLv3+
URL:            http://iipimage.sourceforge.net
Source0:        https://github.com/ruven/%{name}/archive/%{name}-%{iipver}.tar.gz
Source1:        %{name}-httpd.conf
Source2:        README.rpm
Source3:        %{name}-logrotate
Source10:       %{name}.service
Source11:       %{name}.initd
Source12:       %{name}.initd.conf
Patch0:         %{name}-remove-bundled-fcgi.patch

BuildRequires:  gcc-c++
BuildRequires:  zlib-devel
BuildRequires:  libjpeg-devel
BuildRequires:  libtiff-devel libtiffxx-devel
BuildRequires:  libfcgi-devel
BuildRequires:  liblcms2-devel
BuildRequires:  libpng-devel
%if 0%{?fedora}
BuildRequires:  libmemcached-devel
%endif
BuildRequires:  libsystemd-devel libudev-devel systemd systemd-analyze systemd-coredump systemd-networkd systemd-portable systemd-services systemd-stateless systemd-sysvinit systemd-utils
BuildRequires:  autoconf
BuildRequires:  automake
BuildRequires:  libtool
BuildRequires:  selinux-policy-devel
BuildRequires:  checkpolicy

Requires:       %{_sysconfdir}/logrotate.d

Requires(post):   /sbin/restorecon
Requires(post):   /usr/sbin/semanage
Requires(postun): /usr/sbin/semanage
Source44: import.info


%description
Light-weight streaming client-server system for the web-based viewing and
zooming of ultra high-resolution images. It is designed to be bandwidth
and memory efficient and usable even over a slow internet connection.

The system can handle both 8 and 16 bit images, CIELAB colorimetric images and
scientific imagery such as multispectral images. The fast streaming is
tile-based meaning the client only needs to download the portion of the whole
image that is visible on the screen of the user at their current viewing
resolution and not the entire image.
This makes it possible to view, navigate and zoom in real-time around
multi-gigapixel size images that would be impossible to download and
manipulate on the local machine. It also makes the system very scalable as
the number of image tile downloads will remain the same regardless of the
size of the source image. In addition, to reduce the bandwidth necessary even
further, the tiles sent back are dynamically JPEG compressed with a level of
compression that can be optimized for the available bandwidth by the client.


%package httpd-fcgi
Group: Other
Summary:         Apache HTTPD files for %{name}
Requires:        %{name} = %{version}-%{release}
Requires:        apache2-base apache2-htcacheclean
Requires:        mod_fcgid
BuildArch:       noarch


%description httpd-fcgi
IIPImage server Apache/mod_fcgid files


%prep
%setup -q -n %{name}-%{name}-%{iipver}
%patch0 -p1
#fix man
sed -e "s/\.Iiipsrv/.I iipsrv/" -i man/%{name}.8
#specfific fixes for el5...
%if 0%{?rhel}  == 5
sed 's/AC_PROG_MAKE_SET/AC_PROG_MAKE_SET\
AC_PROG_RANLIB/' -i configure.in
mkdir m4
%endif
#remove bundled lib
%if 0%{?rhel}  == 5
#directives names has changed since pre ASF releases of mod_fcgid
#see http://httpd.apache.org/mod_fcgid/mod/mod_fcgid.html#upgrade
sed -i \
  -e 's/FcgidIdleTimeout/IdleTimeout/' \
  -e 's/FcgidMaxProcessesPerClass/DefaultMaxClassProcessCount/' \
  %{SOURCE1}
%endif


%build
./autogen.sh
%configure --with-fcgi-lib=%{_includedir}
%make_build


%install
make install DESTDIR=$RPM_BUILD_ROOT

mkdir -p $RPM_BUILD_ROOT%{_sysconfdir}/httpd/conf.d/
install -m 0644 -D -p %{SOURCE1} ${RPM_BUILD_ROOT}%{_sysconfdir}/httpd/conf.d/%{name}.conf

mkdir -p $RPM_BUILD_ROOT%{_libexecdir}/%{name}
install -m 0755 -D -p src/iipsrv.fcgi $RPM_BUILD_ROOT%{_libexecdir}/%{name}/%{name}.fcgi

cp %{SOURCE2} .

#systemd stuff
mkdir -p $RPM_BUILD_ROOT%{_unitdir}
install -p -m 644 %{SOURCE10} $RPM_BUILD_ROOT%{_unitdir}/%{name}.service

#log stuff
mkdir -p $RPM_BUILD_ROOT%{_localstatedir}/log/%{name}
mkdir -p $RPM_BUILD_ROOT%{_sysconfdir}/logrotate.d
install -m 644 %{SOURCE3} $RPM_BUILD_ROOT%{_sysconfdir}/logrotate.d/%{name}



%post httpd-fcgi
(
# File context
semanage fcontext -a -s system_u -t httpd_log_t -r s0 "%{_localstatedir}/log/%{name}(/.*)?"
# files created by app
restorecon -R %{_localstatedir}/log/%{name}
) &>/dev/null

/bin/systemctl condrestart httpd.service

%pre
%{_sbindir}/useradd -r -s /sbin/nologin %{name} 2> /dev/null || :

%preun
%preun_service %{name}

%post
%post_service %{name}

%postun httpd-fcgi
if [ "$1" -eq "0" ]; then
    # Remove the File Context
    (
    semanage fcontext -d "%{_localstatedir}/log/%{name}(/.*)?"
    ) &>/dev/null
fi
/bin/systemctl condrestart httpd.service


%files
%doc --no-dereference COPYING
%doc README AUTHORS ChangeLog TODO doc/* README.rpm
%{_libexecdir}/%{name}/%{name}.fcgi
%{_unitdir}/%{name}.service
%{_mandir}/man8/%{name}.8*
%dir %{_localstatedir}/log/%{name}
%config(noreplace) %{_sysconfdir}/logrotate.d/%{name}


%files httpd-fcgi
%config(noreplace) %{_sysconfdir}/httpd/conf.d/%{name}.conf


%changelog
