Group: Networking/WWW
# BEGIN SourceDeps(oneline):
BuildRequires(pre): rpm-build-perl rpm-build-python3
BuildRequires: perl(Authen/Passphrase.pm) perl(CGI.pm) perl(DateTime.pm) perl(DateTime/Calendar/Discordian.pm) perl(HTTP/Request.pm) perl(JSON.pm) perl(LWP.pm) perl(LWPx/ParanoidAgent.pm) perl(Locale/gettext.pm) perl(Net/Amazon/S3.pm) perl(Search/Xapian.pm) perl(Search/Xapian/WritableDatabase.pm) perl(UUID/Tiny.pm) perl-podlators
# END SourceDeps(oneline)
%filter_from_requires /^python3(proxy)/d
%add_findreq_skiplist */IkiWiki/Plugin/monotone.pm
%define _libexecdir %_prefix/libexec 
%define fedora 38
# see https://bugzilla.altlinux.org/show_bug.cgi?id=10382
%define _localstatedir %{_var}
Name:           ikiwiki
Version:        3.20250501
Release:        alt1_2
Summary:        A wiki compiler

# ikiwiki is licensed under GPLv2+, the Python code in plugins/ under
# BSD (2-clause)
# SPDX
License:        GPL-2.0-or-later AND BSD-2-Clause
URL:            https://ikiwiki.info/
Source0:        https://ftp.debian.org/debian/pool/main/i/%{name}/%{name}_%{version}.orig.tar.xz
Patch0:         ikiwiki-libexecdir.patch
# Correct t/git.t test
Patch1:         ikiwiki-fakehome.patch
Patch2:         ikiwiki-proxy_py.patch
BuildArch:      noarch

BuildRequires:  coreutils
BuildRequires:  gettext-tools
BuildRequires:  findutils
%if 0%{?rhel} && 0%{?rhel} < 7
BuildRequires:  perl
%else
BuildRequires:  perl-devel
BuildRequires:  rpm-build-perl
%endif
BuildRequires:  perl(ExtUtils/MakeMaker.pm)
BuildRequires:  perl(lib.pm)
# ikiwiki.in loads IkiWiki, IkiWiki::CGI, IkiWiki::Render, IkiWiki::Setup,
# and IkiWiki::Wrapper.
BuildRequires:  perl(strict.pm)
BuildRequires:  perl(warnings.pm)
BuildRequires:  python3-devel
BuildRequires:  sed
# Run-time:
BuildRequires:  perl(CGI/FormBuilder.pm)
BuildRequires:  perl(CGI/Session.pm)
BuildRequires:  perl(constant.pm)
BuildRequires:  perl(Data/Dumper.pm)
BuildRequires:  perl(Date/Format.pm)
BuildRequires:  perl(Date/Parse.pm)
BuildRequires:  perl(Digest/MD5.pm)
BuildRequires:  perl(Digest/SHA.pm)
BuildRequires:  perl(Encode.pm)
BuildRequires:  perl(English.pm)
BuildRequires:  perl(Exporter.pm)
BuildRequires:  perl(Fcntl.pm)
BuildRequires:  perl(File/Basename.pm)
BuildRequires:  perl(File/chdir.pm)
BuildRequires:  perl(File/Copy.pm)
BuildRequires:  perl(File/Find.pm)
BuildRequires:  perl(File/MimeInfo.pm)
BuildRequires:  perl(File/Path.pm)
BuildRequires:  perl(File/ReadBackwards.pm)
BuildRequires:  perl(File/Spec.pm)
BuildRequires:  perl(File/Temp.pm)
BuildRequires:  perl(Getopt/Long.pm)
BuildRequires:  perl(HTML/Entities.pm)
BuildRequires:  perl(HTML/Parser.pm)
BuildRequires:  perl(HTML/Scrubber.pm)
BuildRequires:  perl(HTML/Tagset.pm)
BuildRequires:  perl(HTML/Template.pm)
BuildRequires:  perl(Image/Magick.pm)
BuildRequires:  perl(IO/Handle.pm)
BuildRequires:  perl(IPC/Open2.pm)
BuildRequires:  perl(Locale/Po4a/Chooser.pm)
BuildRequires:  perl(Locale/Po4a/Po.pm)
BuildRequires:  perl(Mail/Sendmail.pm)
BuildRequires:  perl(Memoize.pm)
# Monotone not used at tests
# Net::Amazon::S3 not used at tests
BuildRequires:  perl(open.pm)
BuildRequires:  perl(overload.pm)
BuildRequires:  perl(POSIX.pm)
BuildRequires:  perl(RPC/XML.pm)
BuildRequires:  perl(Storable.pm)
BuildRequires:  perl(Sys/Syslog.pm)
BuildRequires:  perl(Term/ReadLine.pm)
# Text::MultiMarkdown || Text::Markdown::Discount || Text::Markdown || Markdown
# || /usr/bin/markdown
BuildRequires:  perl(Text/Markdown.pm)
BuildRequires:  perl(Time/Local.pm)
BuildRequires:  perl(URI.pm)
BuildRequires:  perl(URI/Escape.pm)
BuildRequires:  perl(utf8.pm)
BuildRequires:  perl(vars.pm)
%if ! 0%{?rhel}
BuildRequires:  perl(XML/Feed.pm)
%endif
BuildRequires:  perl(XML/SAX.pm)
BuildRequires:  perl(XML/Simple.pm)
BuildRequires:  perl(YAML/XS.pm)
# Optional run-time:
# Locale::gettext not used at tests
%if ! 0%{?rhel}
BuildRequires:  perl(Net/OpenID/VerifiedIdentity.pm)
%endif
# UUID::Tiny not used at tests
# Tests:
BuildRequires:  perl(B.pm)
BuildRequires:  perl(Cwd.pm)
BuildRequires:  perl(Errno.pm)
BuildRequires:  perl(Test/More.pm)
# Optional tests:
BuildRequires:  bzr
BuildRequires:  cvs
BuildRequires:  cvsps
BuildRequires:  gcc
BuildRequires:  git-core
BuildRequires:  mercurial mercurial-hgext
BuildRequires:  perl(HTML/LinkExtor.pm)
BuildRequires:  perl(HTML/TreeBuilder.pm)
BuildRequires:  perl(IPC/Run.pm)
BuildRequires:  perl(XML/Twig.pm)
BuildRequires:  python3-module-docutils
BuildRequires:  subversion subversion-server-common

Requires:       perl(CGI/FormBuilder.pm) >= 3.02.02
Requires:       perl(CGI/Session.pm)
Requires:       perl(Digest/SHA.pm)
Requires:       perl(HTML/Scrubber.pm)
Requires:       perl(Image/Magick.pm)
Requires:       perl(Mail/Sendmail.pm)
Requires:       perl(Sys/Syslog.pm)
Requires:       perl(Text/Markdown.pm)
%if ! 0%{?rhel}
Requires:       perl(XML/Feed.pm)
%endif
Requires:       perl(XML/Simple.pm)
Requires:       perl(YAML/XS.pm)

%if "%{?python3_version}" != ""
%endif
Requires:       python3-module-docutils

# IkiWiki package spreads over more files. Provide the file names as modules
# because they are loaded in that way.
Provides:       perl(IkiWiki/Render.pm)
Provides:       perl(IkiWiki/UserInfo.pm)

%global cgi_bin %{_libexecdir}/w3m/cgi-bin

# Remove under-specified dependencies


Source44: import.info
%filter_from_requires /^perl(IkiWiki.pm)/d
%filter_from_provides /^perl(IkiWiki.pm)/d

%description
Ikiwiki is a wiki compiler. It converts wiki pages into HTML pages
suitable for publishing on a website. Ikiwiki stores pages and history
in a revision control system such as Subversion or Git. There are many
other features, including support for blogging, as well as a large
array of plugins.


%prep
%setup -q -n ikiwiki-%{version}
%patch0  -p1
%patch1  -p1
%patch2  -p1

# goes into the -w3m subpackage
cat << \EOF > README.fedora
See http://ikiwiki.info/w3mmode/ for more information.
EOF

# Drop Monotone plugin
# Monotone depends on botan v1, which has been EOL for a long time
rm -v IkiWiki/Plugin/monotone.pm
rm -f t/img.t


%build
/usr/bin/perl Makefile.PL INSTALLDIRS=vendor PREFIX=%{_prefix}
# parallel builds currently don't work
make


%check
make test || :


%install
make pure_install DESTDIR=%{buildroot} W3M_CGI_BIN=%{cgi_bin}
%find_lang %{name}

# move external plugins
mkdir -p %{buildroot}%{_libexecdir}/ikiwiki/plugins
mv %{buildroot}%{_prefix}/lib/ikiwiki/plugins/* \
   %{buildroot}%{_libexecdir}/ikiwiki/plugins

# remove shebang
sed -e '1{/^#!/d}' -i \
    %{buildroot}%{_sysconfdir}/ikiwiki/auto.setup \
    %{buildroot}%{_sysconfdir}/ikiwiki/auto-blog.setup \
    %{buildroot}%{_libexecdir}/ikiwiki/plugins/proxy.py \
    %{buildroot}%{_libexecdir}/ikiwiki/plugins/rst

# fix shebang
sed -e '1i#!%{__python3}' -i \
    %{buildroot}%{_libexecdir}/ikiwiki/plugins/rst

# fix permissions
find %{buildroot}%{perl_vendor_privlib}/IkiWiki -type f \
     -exec chmod -x {} \;

# https://fedoraproject.org/wiki/Changes/Unify_bin_and_sbin
%if 0%{?fedora} >= 42
mv %{buildroot}%{_prefix}/sbin/ikiwiki-mass-rebuild \
   %{buildroot}%{_sbindir}
%endif


%files -f %{name}.lang
%{_bindir}/ikiwiki
%{_bindir}/ikiwiki-calendar
%{_bindir}/ikiwiki-comment
%{_bindir}/ikiwiki-makerepo
%{_bindir}/ikiwiki-transition
%{_bindir}/ikiwiki-update-wikilist
%{_sbindir}/ikiwiki-mass-rebuild
%{_mandir}/man1/ikiwiki*
%{_mandir}/man8/ikiwiki*
%{_datadir}/ikiwiki
%dir %{_sysconfdir}/ikiwiki
%config(noreplace) %{_sysconfdir}/ikiwiki/*
# contains a packlist only
%exclude %{perl_vendor_archlib}
%{perl_vendor_privlib}/IkiWiki*
%exclude %{perl_vendor_privlib}/IkiWiki*/Plugin/skeleton.pm.example
%if 0%{?rhel}
# disable the S3 plugin for now, as perl-Net-Amazon-S3 is not
# available on epel6 (rhbz#1125850)
%exclude %{perl_vendor_privlib}/IkiWiki*/Plugin/amazon_s3.pm
%endif
%{_libexecdir}/ikiwiki
%doc README debian/changelog debian/NEWS html
%doc IkiWiki/Plugin/skeleton.pm.example
%if 0%{?_licensedir:1}
# include license file a second time
%doc --no-dereference html/GPL
%endif


%package w3m
Group: Networking/WWW
Summary:        Ikiwiki w3m cgi meta-wrapper
Requires:       w3m
Requires:       %{name} = %{version}-%{release}

%description w3m
Enable usage of all of ikiwiki's web features (page editing, etc) in
the w3m web browser without a web server. w3m supports local CGI
scripts, and ikiwiki can be set up to run that way using the
meta-wrapper in this package.


%files w3m
%doc README.fedora
%{cgi_bin}/ikiwiki-w3m.cgi


%changelog
