Group: Office
# BEGIN SourceDeps(oneline):
BuildRequires(pre): rpm-build-python3
# END SourceDeps(oneline)
# see https://bugzilla.altlinux.org/show_bug.cgi?id=10382
%define _localstatedir %{_var}
%global	timestamp	20210612
%global	svnversion	311
Name:           impressive
Version:        0.13.0
Release:        alt1_0.9.20210612svn311
Summary:        A program that displays presentation slides

License:        GPLv2
URL:            http://impressive.sourceforge.net/
#Source0:        http://downloads.sourceforge.net/%%{name}/Impressive-%%{version}.tar.gz
# svn export -r ${svnversion} http://svn.emphy.de/impressive/trunk/impressive Impressive-${version}
# make -C Impressive-${version} release
# mv Impressive-${version}/_releases/Impressive-${version}-WIP.tar.gz Impressive-${version}-WIP-${timestamp}svn${svnversion}.tar.gz
Source0:        Impressive-%{version}-WIP-%{timestamp}svn%{svnversion}.tar.gz
# Wrapper script for making sure hardware acceleration is available
Source1:        %{name}.sh

BuildArch:      noarch
BuildRequires:  python3-devel
# The following requires are not picked up by rpm:
# - imported modules (required):
Requires:       python3-module-Pillow
Requires:       python3-module-pygame
Requires:       opengl-games-utils
# - external tools for displaying and parsing pdf (required):
Requires:       mupdf
# - external tool for acting on links (strongly recommended):
Requires:       xdg-utils
# - font for on screen display (recommended):
Requires:       fonts-ttf-dejavu
Source44: import.info


%description
Impressive is a program that displays presentation slides. But unlike 
OpenOffice.org Impress or other similar applications, it does so with 
style. 

Smooth alpha-blended slide transitions are provided for the sake 
of eye candy, but in addition to this, Impressive offers some unique tools 
that are really useful for presentations.


%prep
%setup -q -n Impressive-%{version}-WIP

sed -ie '1s#/usr/bin/env python#/usr/bin/python3#' impressive.py

%build
sed -e "s|@PYTHON_SITELIB@|%{python3_sitelibdir_noarch}|" %{SOURCE1} > impressive.sh
# This package doesn't build anything, just copy files under build root.


%install
install -D -p -m 755 impressive.py %{buildroot}%{python3_sitelibdir_noarch}/impressive.py
install -D -p -m 644 impressive.1 %{buildroot}%{_mandir}/man1/impressive.1
install -D -p -m 755 impressive.sh %{buildroot}%{_bindir}/impressive



%files
%doc changelog.txt demo.pdf impressive.html license.txt
%{_bindir}/impressive
%{python3_sitelibdir_noarch}/impressive.py
#{python3_sitelibdir_noarch}/__pycache__/*
%{_mandir}/man1/impressive.1*

%changelog
