# BEGIN SourceDeps(oneline):
BuildRequires: unzip
# END SourceDeps(oneline)
# see https://bugzilla.altlinux.org/show_bug.cgi?id=10382
%define _localstatedir %{_var}
%define major         1
%define libname       libinchi%{major}
%define libname_devel libinchi-devel
%define inchi_so_ver  1.06.00
%define url_ver       106

Name:          inchi
Version:       1.0.6
Release:       alt1_3
Summary:       The IUPAC International Chemical Identifier
Group:         System/Libraries
License:       LGPLv2+
Url:           https://www.iupac.org/inchi/
Source0:       https://www.inchi-trust.org/download/%{url_ver}/INCHI-1-SRC.zip
Source1:       https://www.inchi-trust.org/download/%{url_ver}/INCHI-1-DOC.zip
Source2:       https://www.inchi-trust.org/download/%{url_ver}/INCHI-1-TEST.zip
Patch0:        inchi-rpm.patch
# reported upstream:
# https://sourceforge.net/p/inchi/bugs/77/
Patch1:        inchi-1.0.6-0001-MolfileReadCountsLine-fix-storing-n_atoms-n_bonds-me.patch
BuildRequires: dos2unix
BuildRequires: glibc-devel glibc-devel-static
Source44: import.info

%description
The IUPAC International Chemical Identifier (InChITM) is a non-proprietary
identifier for chemical substances that can be used in printed and
electronic data sources thus enabling easier linking of diverse data
compilations.* It was developed under IUPAC Project 2000-025-1-800 during
the period 2000-2004. Details of the project and the history of its
progress are available from the project web site.

%package -n %libname
Summary:       The InChI library
Group:         System/Libraries
Provides:      %{name} = %{version}-%{release}

%description -n %libname
The IUPAC International Chemical Identifier.

This package contains the InChI runtime library.

%package -n %libname_devel
Group:         Development/C
Summary:       Development headers for the InChI library
Requires:      %libname = %{version}-%{release}
Provides:      %{name}-devel = %{version}-%{release}

%description -n %libname_devel
The IUPAC International Chemical Identifier.

This package contains header files need for development.

%package doc
Group:         Documentation
Summary:       Documentation for the InChI library
Requires:      %{name} >= %{version}-%{release}
BuildArch:     noarch

%description doc
The IUPAC International Chemical Identifier.

This package contains the development documentation for InChI.

%prep
%setup -q -n INCHI-1-SRC -a 1 -a 2
%patch0  -p1 -b .r
%patch1  -p1 -b .big_endian

for file in readme.txt ; do
  dos2unix -k $file
done
pushd INCHI-1-TEST/test
unzip -d reference -qq -a test-results.zip
unzip -qq -a test-datasets.zip
dos2unix -k reference/*.inc *.sdf
for f in inchify_{InChI_TestSet,zzp} ; do
sed -e 's,REM,#,g' -e 's,/,-,g' -e 's,NUL,/dev/null,g' -e 's,inchi-1.exe,../../INCHI_EXE/bin/Linux/inchi-1,g' ${f}.cmd >${f}.sh
dos2unix ${f}.sh
done
popd

%build
pushd INCHI_API/demos/inchi_main/gcc
%make_build SHARED_LINK_PARM="%{optflags}" OPTFLAGS="%{optflags} -Wno-comment -Wno-parentheses -Wno-unused -Wno-unused-but-set-variable"
popd
pushd INCHI_EXE/inchi-1/gcc
%make_build LINKER_OPTIONS="%{optflags}" OPTFLAGS="%{optflags} -Wno-comment -Wno-parentheses -Wno-unused -Wno-unused-but-set-variable"
popd

%install
mkdir -p %{buildroot}{%{_bindir},%{_libdir},%{_includedir}/inchi}
install -pm 755 INCHI_EXE/bin/Linux/inchi-1 %{buildroot}%{_bindir}/
install -p INCHI_API/bin/Linux/libinchi.so.%{inchi_so_ver} %{buildroot}%{_libdir}
ln -s libinchi.so.%{inchi_so_ver} %{buildroot}%{_libdir}/libinchi.so.%{major}
ln -s libinchi.so.%{major}        %{buildroot}%{_libdir}/libinchi.so
install -pm644 INCHI_BASE/src/{inchi_api,ixa}.h %{buildroot}%{_includedir}/inchi

%files
%{_bindir}/inchi-1

%files -n %libname
%doc --no-dereference LICENCE.pdf
%doc readme.txt
%{_libdir}/libinchi.so.%{major}
%{_libdir}/libinchi.so.%{major}.*

%files -n %libname_devel
%{_includedir}/inchi/
%{_libdir}/libinchi.so

%files doc
%doc INCHI-1-DOC/*


%changelog
