Group: Other
# BEGIN SourceDeps(oneline):
BuildRequires: /usr/bin/desktop-file-validate
# END SourceDeps(oneline)
# see https://bugzilla.altlinux.org/show_bug.cgi?id=10382
%define _localstatedir %{_var}
%define autorelease 3

%global gittag v0.9.82
#%%global commit 1abc907b93a1ba402ca28652de42c81b90c80250
#%%global shortcommit %%(c=%%{commit}; echo ${c:0:7})
#%%global date 20230125

Name:           indistarter
%if "%{?gittag}"
Version:        2.3.2
%else
Version:        2.3.1^%{date}%{shortcommit}
%endif
Release:        alt1_3
Summary:        GUI to start, stop and control an INDI server

License:        GPL-3.0-or-later AND GPL-2.0-only AND GPL-2.0-or-later AND BSD-3-Clause AND MPL-1.1
URL:            https://github.com/pchev/%{name}
%if "%{?gittag}"
Source0:        https://github.com/pchev/%{name}/archive/%{gittag}/%{name}-2.3.2.tar.gz
%else
Source0:        https://github.com/pchev/%{name}/archive/%{commit}/%{name}-%{commit}.tar.gz
%endif

# This patch avoid stripping debuginfo from binary
# Since this is Fedora specific we don't ask upstream to include
Patch100:       indistarter-2.0.0_fix_debuginfo.patch


BuildRequires:  desktop-file-utils
BuildRequires:  fpc-compiler fpc-units-gfx fpc-units-misc fpc-utils
BuildRequires:  lazarus
BuildRequires:  libappstream-glib libappstream-glib-gir
Source44: import.info

%description
Indistarter is a user interface to run a INDI server.
You can configure different profile for your astronomical equipment.
The INDI server can be launched locally or remotely on another computer.
In this last case a ssh tunnel is established to allow local client connection.

%prep
%if "%{?gittag}"
%setup -q
%patch100 -p1

%else
%setup -q -n %{name}-%{commit}
%patch100 -p1

%endif


%build
# Configure script requires non standard parameters
./configure lazarus=%{_libdir}/lazarus prefix=%{_prefix}

# Doesn't like parallel building so we can't use make macro
make fpcopts="-O1 -gw3 -fPIC"


%install
make install PREFIX=%{buildroot}%{_prefix}

# Menu entry
desktop-file-validate %{buildroot}%{_datadir}/applications/*.desktop

# Appdata file check
appstream-util validate-relax --nonet %{buildroot}%{_datadir}/metainfo/*.appdata.xml

%files
%doc --no-dereference gpl-3.0.txt LICENSE
#doc %{_docdir}/%{name}
%{_bindir}/%{name}
%{_bindir}/indigui
%{_datadir}/applications/*.desktop
%{_datadir}/metainfo/%{name}.appdata.xml
%{_datadir}/icons/*/*/*/*.png
%{_datadir}/pixmaps/*.png


%changelog
