Group: System/Libraries
# BEGIN SourceDeps(oneline):
BuildRequires: gcc-c++ glib2-devel pkgconfig(x11)
# END SourceDeps(oneline)
# see https://bugzilla.altlinux.org/show_bug.cgi?id=10382
%define _localstatedir %{_var}
BuildRequires: /usr/bin/git
# %%name is ahead of its definition. Predefining for rpm 4.0 compatibility.
%define name input-pad
%define autorelease 3

%global have_pygobject3_devel 1
%global have_xtest_devel  1

%global sub_version             1.1
%global libxklavier_version     4.0
%global libxml2_version         2.0

%global libinput_paddir %{_libdir}/%{name}-%sub_version
%global moduledir       %{_libdir}/%{name}-%sub_version/modules
%global kbduidir        %{_libdir}/%{name}-%sub_version/modules/kbdui
%global xkeysenddir     %{_libdir}/%{name}-%sub_version/modules/xkeysend


Name:       input-pad
Version:    1.1.0
Release:    alt1_%autorelease
Summary:    On-screen Input Pad to Send Characters with Mouse
License:    LGPL-2.0-or-later
URL:        https://github.com/fujiwarat/input-pad/wiki
Source0:    https://github.com/fujiwarat/input-pad/releases/download/%{version}/%{name}-%{version}.tar.gz
# Patch0:     %%{name}-HEAD.patch


BuildRequires:  gettext-tools libasprintf-devel
BuildRequires:  git
BuildRequires:  gtk3-demo libgail3-devel libgtk+3 libgtk+3-devel libgtk+3-gir-devel
BuildRequires:  libtool
BuildRequires:  libxkbfile-devel
BuildRequires:  libxklavier-devel libxklavier-gir-devel
BuildRequires:  libxml2-devel           >= %libxml2_version
%if %have_xtest_devel
BuildRequires:  libXtst-devel
%endif
%if %have_pygobject3_devel
BuildRequires:  gobject-introspection-devel libgirepository1.0-devel
%endif
%if %have_pygobject3_devel
Requires:       gobject-introspection gobject-introspection-x11
Requires:       python3-module-pygobject3
%endif
Provides:       %{name}-xtest = %{version}-%{release}
Obsoletes:      %{name}-xtest < %{version}-%{release}
Source44: import.info

%description
The input pad is a tool to send a character on button to text applications.

%package devel
Group: Development/Other
Summary:    Development tools for input-pad
Requires:   %{name} = %{version}-%{release}

%description devel
The input-pad-devel package contains the header files.


%prep
%setup -q
%setup -q
git init -q
git config user.name "rpmbuild"
git config user.email "<rpmbuild>"
git config gc.auto 0
git add --force .
git commit -q --allow-empty -a --author "rpmbuild <rpmbuild>" -m "%{NAME}-%{VERSION} base"


%build
#autoreconf -v
%configure \
%if %have_xtest_devel
    --enable-xtest              \
%endif
    --disable-static
%make_build

%install
%makeinstall_std

if [ ! -d $RPM_BUILD_ROOT%kbduidir ] ; then
    mkdir -p $RPM_BUILD_ROOT%kbduidir
fi
if [ ! -d $RPM_BUILD_ROOT%xkeysenddir ] ; then
    mkdir -p $RPM_BUILD_ROOT%xkeysenddir
fi

rm -f $RPM_BUILD_ROOT%{_libdir}/*.la
rm -f $RPM_BUILD_ROOT%{_libdir}/*.a
%if %have_xtest_devel
rm -f $RPM_BUILD_ROOT%xkeysenddir/*.la
rm -f $RPM_BUILD_ROOT%xkeysenddir/*.a
%endif

%find_lang %{name}



%files -f %{name}.lang
%doc AUTHORS COPYING README
%{_bindir}/input-pad
%dir %libinput_paddir
%dir %moduledir
%dir %xkeysenddir
%xkeysenddir/libinput-pad-xtest-gdk.so
%dir %kbduidir
%{_libdir}/libinput-pad-*.so.*
%if %have_pygobject3_devel
%{_libdir}/girepository-1.0/InputPad-%{sub_version}.typelib
%endif
%{_datadir}/%name
%{_datadir}/pixmaps/input-pad.png
%{_mandir}/man1/input-pad.1*

%files devel
%{_includedir}/%{name}-%sub_version
%{_libdir}/libinput-pad-*.so
%{_libdir}/pkgconfig/*.pc
%if %have_pygobject3_devel
%{_datadir}/gir-1.0/InputPad-%{sub_version}.gir
%endif

%changelog
