#tmp hack
ExcludeArch: %{ix86}
# see https://bugzilla.altlinux.org/show_bug.cgi?id=10382
%define _localstatedir %{_var}
# Increase when packaging a newer snapshot
%define mainrel 12
%define date    20170428
# Increase when rebuilding the same snapshot
%define rel 5

Name:           ioquake3
Version:        1.36
Release:        alt1_%{mainrel}.%{date}.%{rel}
Summary:        Quake 3 Arena engine (ioquake3 version)
Group:          Games/Other
License:        GPLv2+
URL:            https://ioquake3.org/
# Snapshot from git repository: https://github.com/ioquake/ioq3
# - Strip thirdparty code:
# rm -rf code/{AL,jpeg-8c,libcurl-*,libogg-*,libspeex,libvorbis-*,opus-*,opusfile-*,SDL2,zlib}
# - Strip nonfree code (lcc) and binaries:
# rm -rf code/libs code/tools/lcc
Source0:        %{name}-%{date}.tar.xz
Source1:        %{name}-demo.sh
Source2:        %{name}.autodlrc
Source3:        %{name}.desktop
Source4:        %{name}.png
Source5:        %{name}-update.sh
Source6:        %{name}-update.autodlrc
Patch0: 	ioquake-1.36-CVE-2017-11721-buffer-overflow.patch

BuildRequires:  pkgconfig(libcurl)
BuildRequires:  pkgconfig(libjpeg)
BuildRequires:  pkgconfig(ogg)
BuildRequires:  pkgconfig(openal)
BuildRequires:  pkgconfig(opus)
BuildRequires:  pkgconfig(opusfile)
BuildRequires:  pkgconfig(sdl2)
BuildRequires:  pkgconfig(vorbis)
BuildRequires:  pkgconfig(vorbisfile)
BuildRequires:  pkgconfig(zlib)
%ifarch %{ix86} x86_64
BuildRequires:  nasm
%endif

# for quake3-update
Requires:       autodownloader 
Source44: import.info

%description
This package contains the enhanced opensource ioquake3 version of the Quake 3
Arena engine. This engine can be used to play a number of games based on this
engine, below is an (incomplete list):

* OpenArena, Free, Open Source Quake3 like game, recommended!
  (packagename: openarena)

* Urban Terror, gratis, but not Open Source FPS best be described as a
  Hollywood tactical shooter, a downloader and installer including an
  application menu entry is available in the urbanterror package.

* World of Padman, gratis, but not Open Source Comic FPS, a downloader and
  installer including an application menu entry is available in the
  worldofpadman package.

* Smokin' Guns, gratis, but not Open Source FPS, a semi-realistic simulation of 
  the "Old West's" great atmosphere, a downloader and installer including an
  application menu entry is available in the smokinguns package.

* Quake3 Arena, the original! A downloader and installer for the gratis, but
  not Open Source demo, including an application menu entry is available in
  the quake3-demo package.
  
  If you own a copy of quake 3, you will need to copy pak0.pk3 from the
  original CD-ROM and your q3key to %{_libexecdir}/quake3/baseq3 or ~/.q3a/baseq3.
  Also copy the pak?.pk3 files from the original 1.32 Quake 3 Arena point
  release there if you have them available or run quake3-update to download
  them for you.


%package demo
Summary:        Quake 3 Arena tournament 3D shooter game demo installer
Group:          Games/Other
Requires:       ioquake3 = %{version}-%{release}
Requires:       opengl-games-utils 
BuildArch:      noarch

%description demo
Quake 3 Arena tournament 3D shooter game demo installer. The Quake3 engine is
Open Source and as such is available as part of Mageia. The original Quake3
data files however are not Open Source and thus are not available as part of
Mageia. There is a gratis, but not Open Source demo available on the internet.

This package installs an application menu entry for playing the Quake3 Arena
demo. The first time you click this menu entry, it will offer to download and
install the Quake 3 demo datafiles for you.


%prep
%setup -q -n %{name}-%{date}
%patch0 -p1


%build
%add_optflags %optflags_shared
export CFLAGS="${CFLAGS:-%optflags}";
export CXXFLAGS="${CXXFLAGS:-%optflags}";
%make \
  BUILD_CLIENT_SMP=1 \
  BUILD_GAME_SO=1 \
  BUILD_GAME_QVM=0 \
  DEFAULT_BASEDIR=%{_libexecdir}/%{name} \
  GENERATE_DEPENDENCIES=0 \
  OPTIMIZE="%{optflags}" \
  USE_CODEC_VORBIS=1 \
  USE_CODEC_OPUS=1 \
  USE_CURL=1 \
  USE_CURL_DLOPEN=0 \
  USE_INTERNAL_LIBS=0 \
  USE_LOCAL_HEADERS=0 \
  USE_OPENAL=1 \
  USE_OPENAL_DLOPEN=0 \
  VERSION="\\\"%{version} (git %{date}) [%{_vendor} %{release}]\\\""


%install
install -d %{buildroot}%{_bindir}
install -d %{buildroot}%{_datadir}/%{name}
install -d %{buildroot}%{_libexecdir}/%{name}/{baseq3,missionpack}

# ioquake3 binaries
pushd build/release-linux-*
install -m 755 %{name}.* %{buildroot}%{_bindir}/%{name}
install -m 755 ioq3ded.* %{buildroot}%{_bindir}/ioq3ded

install -m 755 renderer_opengl*.so %{buildroot}%{_libexecdir}/%{name}/
install -m 755 baseq3/*.so %{buildroot}%{_libexecdir}/%{name}/baseq3/
install -m 755 missionpack/*.so %{buildroot}%{_libexecdir}/%{name}/missionpack/
popd

# script to download the demo
install -m 755 %{SOURCE1} %{buildroot}%{_bindir}/ioquake3-demo
install -m 644 %{SOURCE2} %{buildroot}%{_datadir}/%{name}/

# script to install the latest patch
install -m 755 %{SOURCE5} %{buildroot}%{_bindir}/ioquake3-update
install -m 644 %{SOURCE6} %{buildroot}%{_datadir}/%{name}/

# desktop file and icons
install -D -m 644 misc/setup/%{name}.desktop \
  %{buildroot}%{_datadir}/applications/%{name}.desktop
install -D -m 644 misc/quake3.svg \
  %{buildroot}%{_iconsdir}/hicolor/scalable/apps/quake3.svg
install -D -m 644 misc/quake3.png \
  %{buildroot}%{_iconsdir}/hicolor/32x32/apps/quake3.png

%files
%doc md4-readme.txt opengl2-readme.md README.md voip-readme.txt
%doc --no-dereference COPYING.txt id-readme.txt
%{_bindir}/%{name}
%{_bindir}/%{name}-update
%{_bindir}/ioq3ded
%{_datadir}/%{name}/%{name}-update.autodlrc
%{_datadir}/applications/%{name}.desktop
%{_iconsdir}/hicolor/32x32/apps/quake3.png
%{_iconsdir}/hicolor/scalable/apps/quake3.svg
%dir %{_libexecdir}/%{name}
%{_libexecdir}/%{name}/baseq3/
%{_libexecdir}/%{name}/missionpack/
%{_libexecdir}/%{name}/renderer_opengl*.so

%files demo
%{_bindir}/%{name}-demo
%{_datadir}/%{name}/%{name}.autodlrc


%changelog
