Group: Other
# see https://bugzilla.altlinux.org/show_bug.cgi?id=10382
%define _localstatedir %{_var}
%{!?username:%global username	ip-sentinel}
%global service		ip-sentinel
%global apphomedir		%{_var}/lib/ip-sentinel

Summary:	Tool to prevent unauthorized usage of IP addresses
Name:		ip-sentinel
Version:	0.12
Release:	alt2_1933
License:	GPL-2.0-only
URL:		http://www.nongnu.org/ip-sentinel/
Source0:	http://savannah.nongnu.org/download/ip-sentinel/%{name}-%{version}.tar.bz2
Source1:	http://savannah.nongnu.org/download/ip-sentinel/%{name}-%{version}.tar.bz2.sig
Source2:	ip-sentinel.service
Patch0:		ip-sentinel-0.12-pidfile.patch
Patch1:		ip-sentinel-0.12-glibc.patch
Provides:	user(%username) = 1
Provides:	group(%username) = 1
BuildRequires:  gcc
BuildRequires:	which libsystemd-devel libudev-devel systemd systemd-analyze systemd-homed systemd-networkd
Obsoletes: ip-sentinel-sysvinit < %{version}-%{release}
Provides: ip-sentinel-sysvinit = %{version}-%{release}
Obsoletes: ip-sentinel-minit < %{version}-%{release}
Provides: ip-sentinel-minit = %{version}-%{release}
Obsoletes: ip-sentinel-upstart < %{version}-%{release}
Provides: ip-sentinel-upstart = %{version}-%{release}
Source44: import.info


%description
IP Sentinel is a tool that tries to prevent unauthorized usage of
IP addresses within an ethernet broadcast domain by answering ARP
requests. After receiving faked replies, requesting parties store
the MAC in their ARP tables and will send future packets to this
invalid MAC, rendering the IP unreachable.


%prep
%setup -q
%patch0  -p0 -b .pidfile
%patch1  -p0

# Create a sysusers.d config file
cat >ip-sentinel.sysusers.conf <<EOF
u ip-sentinel - 'IP sentinel user' %{apphomedir} -
EOF

%build
%configure --enable-release \
	   --with-initrddir=%{_initrddir} \
	   --with-username=%username \
           --disable-dietlibc
%make_build all


%install

make DESTDIR=$RPM_BUILD_ROOT install install-contrib
install -m750 -d $RPM_BUILD_ROOT%apphomedir
rm -rf $RPM_BUILD_ROOT%{_sysconfdir}/minit/
rm -rf $RPM_BUILD_ROOT%{_sysconfdir}/rc.d/init.d/ip-sentinel


install -Dpm 755 %{SOURCE2} $RPM_BUILD_ROOT%{_unitdir}/ip-sentinel.service

install -m0644 -D ip-sentinel.sysusers.conf %{buildroot}%{_sysusersdir}/ip-sentinel.conf

%check
make check




%post
%post_service ip-sentinel

%preun
%preun_service ip-sentinel

%files
%doc AUTHORS COPYING ChangeLog NEWS README THANKS
%{_mandir}/*/*
%{_sbindir}/*
%{_unitdir}/ip-sentinel.service
%{_sysconfdir}/sysconfig/ip-sentinel
%attr(-,root,%username) %apphomedir
%{_sysusersdir}/ip-sentinel.conf

%changelog
