BuildRequires: perl(CGI.pm)
Name:           ipcalculator
Version:        0.41
Release:        alt1_18
Summary:        A utility for computing broadcast, network, mask, and host ranges

Group:          Networking/WWW
License:        GPLv2+
URL:            http://jodies.de/ipcalc
Source0:        http://jodies.de/ipcalc-archive/ipcalc-%{version}.tar.gz
Source1:        ipcalculator.conf
Source2:        bg.gif

BuildArch:      noarch
Source44: import.info

%package cgi
Summary:        A CGI wrapper for ipcalculator
Group:          Networking/WWW

Requires:       ipcalculator
Requires:       httpd

# fixes the URLS in ipcalculator.cgi 
Patch0:         ipcalculator-hrefs.patch

%description
ipcalculator takes an IP address and netmask and calculates the resulting
broadcast, network, Cisco wildcard mask, and host range. By giving a second
netmask, you can design subnets and supernets. It is also intended to be
a teaching tool and presents the subnetting results as easy-to-understand
binary values.

%description cgi
ipcalculator-cgi contains a CGI wrapper around the ipcalculator script. It
allows you to embed ipcalculator's functionality into a web page.


%prep
%setup -q -n ipcalc-%{version}
# "ipcalc" is hardcoded into the help and usage messages. We don't want to
# substitute everything since there are mentions of ipcalc in URLs etc.
sed -i '1041,1085s/ipcalc/ipcalculator/g' ipcalc
# the cgi wrapper uses hardcoded path to a different location
sed -i 's:/usr/local/bin/ipcalc:%{_bindir}/ipcalculator:' ipcalc.cgi
%patch0 -p1 -b .hrefs


%build


%install

mkdir -p $RPM_BUILD_ROOT%{_bindir}
mkdir -p $RPM_BUILD_ROOT%{_datadir}/%{name}

install -pm 644 ipcalc.gif $RPM_BUILD_ROOT%{_datadir}/%{name}/ipcal03.gif
install -pm 644 ipcalculator.png \
    $RPM_BUILD_ROOT%{_datadir}/%{name}/ipcalculator.png
install -pm 755 ipcalc $RPM_BUILD_ROOT%{_bindir}/ipcalculator

## CGI wrapper install
install -Dpm 644 %{SOURCE1}  \
    $RPM_BUILD_ROOT%{_sysconfdir}/httpd/conf.d/ipcalculator.conf
install -Dpm 755 ipcalc.cgi \
   $RPM_BUILD_ROOT%{_datadir}/%{name}/ipcalculator.cgi
install -Dpm 644 %{SOURCE2}  \
   $RPM_BUILD_ROOT%{_datadir}/%{name}/bg.gif

%files
%doc changelog contributors license
%dir %{_datadir}/%{name}
%{_bindir}/ipcalculator

%files cgi
%dir %{_datadir}/%{name}
%config(noreplace) %{_sysconfdir}/httpd/conf.d/ipcalculator.conf
%{_datadir}/%{name}/ipcal03.gif
%{_datadir}/%{name}/bg.gif
%{_datadir}/%{name}/ipcalculator.png
%{_datadir}/%{name}/ipcalculator.cgi



%changelog
