Group: Networking/WWW
# see https://bugzilla.altlinux.org/show_bug.cgi?id=10382
%define _localstatedir %{_var}

Name:           irc-otr
Version:        1.0.2
Release:        alt2_24
Summary:        Off-The-Record Messaging plugin for irssi
# Automatically converted from old format: GPLv2+ - review is highly recommended.
License:        GPL-2.0-or-later
URL:            https://github.com/cryptodotis/irssi-otr
Source:         https://github.com/cryptodotis/irssi-otr/archive/v%{version}.tar.gz#/irssi-otr-%{version}.tar.gz

Provides:       irssi-otr = %{version}-%{release}
Obsoletes:      irssi-otr < 1.0.0-1

BuildRequires:  glib2-devel libgio libgio-devel
BuildRequires:  irssi-devel >= 0.8.15
BuildRequires:  libotr-devel >= 4.1.0
BuildRequires:  libgcrypt-devel >= 1.5.0
BuildRequires:  autoconf
BuildRequires:  automake
BuildRequires:  libtool
Source44: import.info

%description
This provides modules which implement Off-The-Record (OTR) Messaging
for the irssi IRC client.

%prep
%setup -q -n irssi-otr-%{version}

%build
./bootstrap
%configure --with-irssi-module-dir=%{_libdir}/irssi/modules
%make_build

%install
make install DESTDIR=$RPM_BUILD_ROOT
chmod +x $RPM_BUILD_ROOT%{_libdir}/irssi/modules/libotr.so

%files
%doc README.md ChangeLog
%doc --no-dereference LICENSE
%{_libdir}/irssi/modules/libotr.so
%{_datadir}/irssi/help/otr

%changelog
