# BEGIN SourceDeps(oneline):
BuildRequires: rpm-build-java
# END SourceDeps(oneline)
# see https://bugzilla.altlinux.org/show_bug.cgi?id=10382
%define _localstatedir %{_var}
Name:          irclib
Version:       1.10
Release:       alt1_6
Group:         Development/Java
Summary:       Java implementation of the IRC protocol
License:       ASL 2.0 and EPL and LGPLv2+
URL:           http://moepii.sourceforge.net/
Source0:       http://prdownloads.sourceforge.net/moepii/%{name}-%{version}.tar.gz
Source1:       http://repo2.maven.org/maven2/org/schwering/%{name}/%{version}/%{name}-%{version}.pom

BuildRequires: java-devel-default /proc
BuildRequires: javapackages-local
BuildArch:     noarch
Source44: import.info

%description
IRClib is pure Java 1.2 IRC implementation. The
IRClib library is designed very cleanly, supports
RFC1459 and supports SSL connections.

%package javadoc
Group: Development/Java
Summary:       Javadoc for %{name}
BuildArch: noarch

%description javadoc
This package contains javadoc for %{name}.

%prep
%setup -q
# cleanup
find -name "*.jar" -delete
find -name "*.class" -delete
rm -r $(find -name ".svn")
rm -r javadoc

# fix spurious-executable-perm
chmod 644 CHANGELOG COPYING_AL COPYING_EPL COPYING_LGPL README
# fix incorrect-fsf-address
sed -i "s,59 Temple Place,51 Franklin Street,;s,Suite 330,Fifth Floor,;s,02111-1307,02110-1301," COPYING_LGPL
# fix wrong-script-end-of-line-encoding
sed -i 's/\r//' CHANGELOG COPYING_AL COPYING_EPL COPYING_LGPL README

%mvn_file org.schwering:%{name} %{name}

%build

mkdir -p classes docs
%javac -d classes -source 1.6 -target 1.6 $(find src -name "*.java")

(
cd classes
%jar -cf ../%{name}.jar *
)

%javadoc -source 1.6 -classpath classes -d docs -Xdoclint:none $(find src -name "*.java")

%install
%mvn_artifact %{SOURCE1} %{name}.jar
%mvn_install -J docs

%files -f .mfiles
%doc CHANGELOG README
%doc --no-dereference COPYING_AL COPYING_EPL COPYING_LGPL

%files javadoc -f .mfiles-javadoc
%doc --no-dereference COPYING_AL COPYING_EPL COPYING_LGPL



%changelog
