Group: Sound
# BEGIN SourceDeps(oneline):
BuildRequires(pre): rpm-macros-cmake rpm-macros-fedora-compat
BuildRequires: /usr/bin/desktop-file-install gcc-c++ libX11-devel
# END SourceDeps(oneline)
# see https://bugzilla.altlinux.org/show_bug.cgi?id=10382
%define _localstatedir %{_var}
Name:		jack-keyboard
Version:	2.7.2
Release:	alt2_6
Summary:	Virtual keyboard for JACK MIDI
License:	BSD
URL:		http://sourceforge.net/projects/jack-keyboard/
Source0:	http://downloads.sourceforge.net/%{name}/%{name}-%{version}.tar.gz
# Icon is derived from the image on the website:
Source1:	%{name}.png
# Upstreamable patch. Fix DSO linking
Patch0:		%{name}-dso-linking.patch
# cmake should look for gcc only
Patch1:		jack-keyboard-cproject.patch
BuildRequires:	ctest cmake
BuildRequires:	desktop-file-utils
BuildRequires:	gcc
BuildRequires:	gtk-builder-convert gtk-demo libgail-devel libgtk+2-devel
BuildRequires:	libjack-devel
BuildRequires:	liblash-devel
Source44: import.info

%description
jack-keyboard is a virtual MIDI keyboard - a program that allows you to send
JACK MIDI events using your PC keyboard. It is somewhat similar to vkeybd,
except it uses JACK MIDI instead of ALSA, and the default keyboard mapping is
much better - it uses the same layout as trackers (like Impulse Tracker) did,
so you have two and half octaves under your fingers.

%prep
%setup -q
%patch0 -p1 -b .dso.linking
%patch1 -p1 -b .cproject

# Add GenericName to the desktop file
echo "GenericName=Virtual MIDI Keyboard" >> src/%{name}.desktop

# Fix man dir
sed -i 's|man/man1|%{_mandir}/man1|' CMakeLists.txt

%build
%{fedora_v2_cmake}
%fedora_v2_cmake_build

%install
%fedora_v2_cmake_install

rm -fr $RPM_BUILD_ROOT/%{_datadir}/pixmaps/
mkdir -p $RPM_BUILD_ROOT/%{_datadir}/icons/hicolor/72x72/apps/
install -pm 644	%{SOURCE1} \
	$RPM_BUILD_ROOT/%{_datadir}/icons/hicolor/72x72/apps/

desktop-file-install						\
	--dir=$RPM_BUILD_ROOT%{_datadir}/applications		\
	--add-category=X-Jack					\
	$RPM_BUILD_ROOT/%{_datadir}/applications/%{name}.desktop

%files
%doc AUTHORS NEWS README.md TODO
%doc --no-dereference COPYING
%{_bindir}/%{name}
%{_mandir}/man1/%{name}*
%{_datadir}/icons/hicolor/72x72/apps/%{name}.png
%{_datadir}/applications/%{name}.desktop


%changelog
