Group: System/Base
%define _unpackaged_files_terminate_build 1
%define fedora 38
# see https://bugzilla.altlinux.org/show_bug.cgi?id=10382
%define _localstatedir %{_var}
# Don't provide any font Provides
%global	__fontconfig_provides	%{nil}
# ... and it seems that the above method no longer works
# on F-15 (bug 677760)
%global	__font_provides	%{nil}

Summary:   Japanese Console for Linux Frame Buffer Device
Name:      jfbterm
Version:   0.4.7
Release:   alt2_57
# COPYING		BSD-2-Clause
# SPDX confirmed
License:   BSD-2-Clause
Source0:   http://downloads.sourceforge.jp/jfbterm/13501/jfbterm-%{version}.tar.gz
Patch0:    jfbterm-0.4.6-conf.patch
#Patch1:    jfbterm-0.4.6-Makefile.patch
Patch1:    jfbterm-0.4.7-remove-sticky.patch
#Patch2:   jfbterm-0.4.6-x86_64.patch
Patch3:    jfbterm-0.4.7-infinite_loop.patch
# What is patch4 for??
#Patch4:    jfbterm-0.4.7-configure-header.patch
Patch5:    jfbterm-0.4.7-userspace.patch
Patch10:   jfbterm-0.4.7-remove-warning.patch
Patch11:   jfbterm-0.4.7-mmap-newkernel.patch
Patch12:   jfbterm-0.4.7-hang-onexit.patch
Patch13:   jfbterm-0.4.7-pagemask_userspace.patch
# Some people see jfbterm hang or segv with invalid ut_id
# (bug 698532)
Patch15:   jfbterm-0.4.7-hang-on-utmp-refresh-with-invalid-utid.patch
Patch16:   jfbterm-0.4.7-wrong-inline-gcc5.patch
Patch17:   jfbterm-configure-c99.patch

URL:         http://jfbterm.sourceforge.jp/

BuildRequires:   gcc
BuildRequires:   gzip gzip-utils
# BuildRequires:   autoconf
# for tic
BuildRequires:   termutils termutils-devel
# Now efont-unicode-bdf is split.
BuildRequires:   fonts-bitmap-efont-unicode
BuildRequires:   fonts-bitmap-misc
BuildRequires:   fonts-bitmap-japanese
BuildRequires:   fonts-bitmap-jisksp16-1990
Source44: import.info
# Now fonts are symlinks so really these rpms are required.
#Requires:   efont-unicode-bdf
#Requires:   xorg-x11-fonts-base
#Requires:   xorg-x11-fonts-misc
#Requires:   japanese-bitmap-fonts

%description
JFBTERM/ME takes advantages of framebuffer device that is 
supported since linux kernel 2.2.x (at least on ix86 architecture) 
and make it enable to display multilingual text on console. 
It is developed on ix86 architecture, and it will works on 
other architectures such as linux/ppc.

Features:
   * It works with framebuffer device instead of VGA.
   * It supports pcf format font
   * It is not so fast because it doesn't take any advantages 
     of accelaration.
   * It also support coding systems other than ISO-2022, 
     such as SHIFT-JIS by using iconv(3).
   * It is userland program.

%prep
%setup -q
%patch0  -p1 -b .conf
%patch1  -p1 -b .remove_sticky
%patch5  -p1 -b .userspace
%patch3  -p1 -b .infinite_loop
# ???
#%%patch4 -p1 -b .conf_header
%patch10  -p1 -b .remove_warn
%patch11  -p1 -b .nmap_newkernel
%patch12  -p1 -b .hang_onexit
%patch13  -p1 -b .pagemask
%patch15  -p1 -b .utid_with_refresh
%patch16  -p1 -b .inline_gcc5
%patch17  -p1

#autoconf
touch Makefile.in aclocal.m4 config.h.in configure stamp-h.in

%build
# Copy fonts for a moment.
cp -p %{_datadir}/fonts/bitmap/efont-unicode/b16.pcf.gz fonts/

%configure --enable-direct-color
touch stamp-h
make %{?_smp_mflags}

tic -C terminfo.jfbterm > jfbterm.termcap

%install

mkdir -p %{buildroot}%{_sysconfdir}
mkdir -p %{buildroot}%{_datadir}/fonts/jfbterm

make DESTDIR=%{buildroot} install

mv %{buildroot}%{_sysconfdir}/jfbterm.conf.sample \
   %{buildroot}%{_sysconfdir}/jfbterm.conf

mkdir -p %{buildroot}%{_mandir}/man1
mkdir -p %{buildroot}%{_mandir}/man5
install -m 644 jfbterm.1 %{buildroot}%{_mandir}/man1
install -m 644 jfbterm.conf.5 %{buildroot}%{_mandir}/man5

mkdir -p %{buildroot}%{_datadir}/terminfo/j
tic -o %{buildroot}%{_datadir}/terminfo terminfo.jfbterm

# install fonts by symlink
# for fc5 and above, X11R6 directory is no longer used.
#%%{__rm} -rf %{buildroot}%{_datadir}/fonts/jfbterm/*

cp -p \
   %{_datadir}/fonts/bitmap/efont-unicode/b16.pcf.gz \
   %{buildroot}%{_datadir}/fonts/jfbterm/

# For hanglg16, see https://bugzilla.redhat.com/show_bug.cgi?id=1952723
for font in \
   shnm8x16r.pcf.gz shnmk16.pcf.gz jisksp16-1990.pcf.gz \
   8x16.pcf.gz gb16fs.pcf.gz \
%if 0%{?fedora} < 34
   hanglg16.pcf.gz \
%endif
   ; do
   status=1
   for path in \
      %{_datadir}/fonts/bitmap/japanese-bitmap-fonts \
      %{_datadir}/fonts/{japanese,ja}/misc \
      %{_datadir}/fonts/bitmap/jisksp16-1990-fonts \
      %{_datadir}/fonts/bitmap/jisksp16-1990 \
      %{_datadir}/fonts/bitmap/japanese-bitmap \
      %{_datadir}/fonts/bitmap/misc \
       ; do
      if [ -f $path/$font -a $status = 1 ] ; then
         cp -p $path/$font %{buildroot}%{_datadir}/fonts/jfbterm/
         status=0
         break
      fi
   done
   if [ $status = 1 ] ; then exit 1 ; fi
done

status=1
for num in `seq 1 15` ; do
   font=8x13-ISO8859-${num}.pcf.gz
   path=%{_datadir}/fonts/bitmap/misc
   if [ -f $path/$font ] ; then
    cp -p $path/$font %{buildroot}%{_datadir}/fonts/jfbterm/
    status=0
   fi
done
if [ $status = 1 ] ; then exit 1 ; fi

cat > 60-jfbterm.perms <<EOF
# permission definitions
<console> 0660 /dev/tty0    0660 root
<console> 0600 /dev/console 0600 root
EOF

mkdir -p -m 755 %{buildroot}%{_sysconfdir}/security/console.perms.d
install -m 644 60-jfbterm.perms \
   %{buildroot}%{_sysconfdir}/security/console.perms.d/

# Change documents' fonts to UTF-8
sed -i -e 's|\r||' AUTHORS

for f in AUTHORS ChangeLog ; do
   mv ${f} ${f}.orig
   iconv -f ISO-2022-JP -t UTF8 ${f}.orig > ${f} && \
   rm -f ${f}.orig || mv ${f}.orig ${f}
done
mv README.ja README.ja.orig
iconv -f EUCJP -t UTF8 README.ja.orig > README.ja && \
   rm -f README.ja.orig || mv README.ja.orig README.ja

# Remove terminfo from FC-7
rm -rf %{buildroot}%{_datadir}/terminfo/

%files
%doc AUTHORS
%doc --no-dereference COPYING
%doc ChangeLog
%doc NEWS
%doc README*
%doc jfbterm.termcap
%{_bindir}/jfbterm
%config(noreplace) %{_sysconfdir}/jfbterm.conf
%config(noreplace) %{_sysconfdir}/security/console.perms.d/60-jfbterm.perms
%{_datadir}/fonts/jfbterm
%{_mandir}/man1/jfbterm.1*
%{_mandir}/man5/jfbterm.conf.5*

%changelog
