# BEGIN SourceDeps(oneline):
BuildRequires(pre): rpm-macros-java
# END SourceDeps(oneline)
# see https://bugzilla.altlinux.org/show_bug.cgi?id=10382
%define _localstatedir %{_var}
Name:		jfor
Version:	0.7.2
Release:	alt1_0.rc1.10
Epoch:		1
Summary:	XSL-FO to RTF converter
Group:		Development/Java
URL:		http://sourceforge.net/projects/jfor/
Source:		http://surfnet.dl.sourceforge.net/sourceforge/jfor/jfor-src-V_0_7_2rc1.tar.gz
License:	ASL 2.0
BuildRequires:	ant
BuildRequires:	avalon-logkit
BuildRequires:	java-devel-default /proc
BuildRequires:	junit
BuildRequires:	javapackages-tools
BuildRequires:	log4j12
BuildRequires:	xerces-j2
BuildArch:	noarch
Source44: import.info

%description
jfor ("Java FO to Rtf converter") converts XSL-FO documents to RTF format. The project is
inactive, code has been donated to the Apache FOP project where it lives on,
see http://xmlgraphics.apache.org/fop/

%package	javadoc
Group:		Development/Java
Summary:	Javadoc for %{name}
BuildArch: noarch

%description javadoc
jfor ("Java FO to Rtf converter") converts XSL-FO documents to RTF format. The project is
inactive, code has been donated to the Apache FOP project where it lives on,
see http://xmlgraphics.apache.org/fop/

This package contains javadoc for %{name}.

%prep
%setup -q -n jfor

for j in $(find . -name "*.jar"); do
  mv $j $j.no
done

pushd lib
  ln -sf $(build-classpath xerces-j2) xerces-1.2.3.jar
  ln -sf $(build-classpath avalon-logkit) logkit-1.0.1.jar
popd

for file in src/org/jfor/jfor/converter/AbstractBuilder.java \
	src/org/jfor/jfor/converter/AfterBuilder.java \
	src/org/jfor/jfor/converter/BeforeBuilder.java \
	src/org/jfor/jfor/converter/Converter.java \
	src/org/jfor/jfor/converter/PageNumberCitationBuilder.java \
	src/org/jfor/jfor/converter/ParagraphBuilder.java \
	src/org/jfor/jfor/converter/TableAttributesConverter.java \
	src/org/jfor/jfor/converter/TableBuilder.java \
	src/org/jfor/jfor/converter/TableCellBuilder.java \
	src/org/jfor/jfor/converter/TableContext.java \
	src/org/jfor/jfor/converter/TableRowBuilder.java \
	src/org/jfor/jfor/converter/TextAttributesConverter.java \
	src/org/jfor/jfor/interfaces/ITableColumnsInfo.java \
	src/org/jfor/jfor/main/JForVersionInfo.java \
	src/org/jfor/jfor/rtflib/rtfdoc/BorderAttributesConverter.java \
	src/org/jfor/jfor/rtflib/rtfdoc/IRtfPageNumberCitationContainer.java \
	src/org/jfor/jfor/rtflib/rtfdoc/IRtfTableContainer.java \
	src/org/jfor/jfor/rtflib/rtfdoc/IRtfTableContainer.java \
	src/org/jfor/jfor/rtflib/rtfdoc/RtfAfterBeforeBase.java \
	src/org/jfor/jfor/rtflib/rtfdoc/RtfAttributes.java \
	src/org/jfor/jfor/rtflib/rtfdoc/RtfColorTable.java \
	src/org/jfor/jfor/rtflib/rtfdoc/RtfContainer.java \
	src/org/jfor/jfor/rtflib/rtfdoc/RtfElement.java \
	src/org/jfor/jfor/rtflib/rtfdoc/RtfExtraRowSet.java \
	src/org/jfor/jfor/rtflib/rtfdoc/RtfPageNumber.java \
	src/org/jfor/jfor/rtflib/rtfdoc/RtfPageNumberCitation.java \
	src/org/jfor/jfor/rtflib/rtfdoc/RtfParagraph.java \
	src/org/jfor/jfor/rtflib/rtfdoc/RtfSection.java \
	src/org/jfor/jfor/rtflib/rtfdoc/RtfTable.java \
	src/org/jfor/jfor/rtflib/rtfdoc/RtfTableCell.java \
	src/org/jfor/jfor/rtflib/rtfdoc/RtfTableRow.java \
	src/org/jfor/jfor/rtflib/rtfdoc/RtfText.java \
	src/org/jfor/jfor/rtflib/testdocs/ListInTable.java \
	src/org/jfor/jfor/rtflib/testdocs/MergedTableCells.java \
	src/org/jfor/jfor/rtflib/testdocs/NestedTable.java \
	src/org/jfor/jfor/rtflib/testdocs/SimpleTable.java; do \
	native2ascii -encoding UTF8 $file $file
done

%build
export CLASSPATH=$(build-classpath junit avalon-logkit log4j xerces-j2)
ant clean dist javadoc

%install
mkdir -p %{buildroot}%{_javadir}

install -pm 644 dist/lib/jfor.jar \
  %{buildroot}%{_javadir}/jfor-%{version}.jar

(
  cd %{buildroot}%{_javadir}
  for jar in *-%{version}*; do 
    ln -sf ${jar} ${jar/-%{version}/}
  done
)

mkdir -p %{buildroot}%{_javadocdir}/jfor-%{version}
cp -pr build/docs/api/* %{buildroot}%{_javadocdir}/jfor-%{version}
ln -sf jfor-%{version} %{buildroot}%{_javadocdir}/jfor

%files
%{_javadir}/jfor-%{version}.jar
%{_javadir}/jfor.jar
%doc legal

%files javadoc
%{_javadocdir}/jfor-%{version}
%{_javadocdir}/jfor


%changelog
