Group: Other
# BEGIN SourceDeps(oneline):
BuildRequires(pre): rpm-macros-fedora-compat
# END SourceDeps(oneline)
%define fedora 30
# see https://bugzilla.altlinux.org/show_bug.cgi?id=10382
%define _localstatedir %{_var}
%global commitdate  20140204
%global commit      3d7767b6b1f3da363c625ff54e63bbf20e9e83ac
%global shortcommit %(c=%{commit}; echo ${c:0:7})

%if 0%{?fedora}
%global installdir  %{_jsdir}/json
%else
%global installdir  %{_datadir}/javascript/json
%endif

Name:            js-json
Version:         %{commitdate}git%{shortcommit}
Release:         alt1_14
Summary:         An implementation of JSON encoders/decoders in JavaScript

License:         Public Domain
URL:             https://github.com/douglascrockford/JSON-js
Source0:         https://github.com/douglascrockford/JSON-js/archive/%{commit}/%{name}-%{version}.tar.gz

BuildArch:       noarch

%if 0%{?fedora}
BuildRequires:   web-assets-devel
Requires:        web-assets-filesystem
%endif
Source44: import.info

%description
JSON is a light-weight, language independent, data interchange format.
See http://www.JSON.org/

This software is an implementation of JSON encoders/decoders in Javascript.

json2.js: This file creates a JSON property in the global object, if there
isn't already one, setting its value to an object containing a stringify
method and a parse method. The parse method uses the eval method to do the
parsing, guarding it with several regular expressions to defend against
accidental code execution hazards. On current browsers, this file does nothing,
preferring the built-in JSON object.

json.js: This file does everything that json2.js does. It also adds a
toJSONString method and a parseJSON method to Object.prototype. Use of this
file is not recommended.

json_parse.js: This file contains an alternative JSON parse function that
uses recursive descent instead of eval.

json_parse_state.js: This files contains an alternative JSON parse function that
uses a state machine instead of eval.

cycle.js: This file contains two functions, JSON.decycle and JSON.retrocycle,
which make it possible to encode cyclical structures and dags in JSON, and to
then recover them. JSONPath is used to represent the links.
http://GOESSNER.net/articles/JsonPath/


%prep
%setup -q -n JSON-js-%{commit}


%build
# nothing to do

%install
mkdir -p %{buildroot}%{installdir}
install -p -m0644 -D cycle.js \
    %{buildroot}%{installdir}/cycle.js
install -p -m0644 -D json.js \
    %{buildroot}%{installdir}/json.js
install -p -m0644 -D json2.js \
    %{buildroot}%{installdir}/json2.js
install -p -m0644 -D json_parse.js \
    %{buildroot}%{installdir}/json_parse.js
install -p -m0644 -D json_parse_state.js \
    %{buildroot}%{installdir}/json_parse_state.js


%files
%doc README
%{installdir}


%changelog
