# BEGIN SourceDeps(oneline):
BuildRequires: gcc-c++
# END SourceDeps(oneline)
# fedora bcond_with macro
%define bcond_with() %{expand:%%{?_with_%{1}:%%global with_%{1} 1}}
%define bcond_without() %{expand:%%{!?_without_%{1}:%%global with_%{1} 1}}
# redefine altlinux specific with and without
%define with()         %{expand:%%{?with_%{1}:1}%%{!?with_%{1}:0}}
%define without()      %{expand:%%{?with_%{1}:0}%%{!?with_%{1}:1}}
%define fedora 19
# Disable the gtk frontend by default, it depends on stuff
# to be obsoleted soonish (and which is not in EPEL 6)
%bcond_with gtk

Name:           justmoon
Version:        0.3.3
Release:        alt1_12
Summary:        Just Moon is lunar observing software for Linux

Group:          Toys
License:        GPL+
URL:            http://www.shallowsky.com/software/justmoon/
Source0:        http://www.shallowsky.com/software/justmoon/%{name}-%{version}.tar.gz
Source1:        justmoon-gmoon.desktop
Source2:        justmoon-qmoon.desktop
# Not sent to upstream yet
Patch0:         justmoon-0.3.3-parenth.patch
# Not upstreamable
Patch1:         justmoon-0.3.3-datadir.patch

BuildRequires:  qt3-devel
%if %with gtk
BuildRequires:  gtk+-devel
BuildRequires:  gdk-pixbuf-devel
%endif
BuildRequires:  desktop-file-utils
Source44: import.info

%description
%{summary}


%if %with gtk
%package gtk
Summary:        GTK+ frontend for Just Moon, a lunar observing software
Group:          Toys
Requires:       %{name}-common = %{version}

%description gtk
This package contains a lunar observing software with
GTK+-based user interface that fits the GNOME Desktop environment.
%endif


%package qt
Summary:        QT frontend for Just Moon, a lunar observing software
Group:          Toys
Requires:       %{name}-common = %{version}
%if %without gtk
Obsoletes:      %{name}-gtk < %{version}-%{release}
%endif

%description qt
This package contains a lunar observing software with
QT-based user interface that fits the KDE Desktop environment.


%package common
Summary:        Data files for Just Moon, a lunar observing software
Group:          Toys

%description common
This package contains data file for a lunar observing software Just Moon.
In order to actually use Just Moon you need a graphical frontend from
justmoon-qt or justmoon-gtk package.


%prep
%setup -q
%patch0 -p1 -b .parenth
%patch1 -p1 -b .datadir


%build
. /etc/profile.d/qt3dir.sh; export PATH=%_libdir/qt3/bin:$PATH
make %{?_smp_mflags}                                            \
        'CFLAGS=%{optflags} -DDATADIR=\"%{_datadir}/%{name}/\"' \
        'CXXFLAGS=%{optflags} -DDATADIR=\"%{_datadir}/%{name}/\"' \
%if %with gtk
        gmoon \
%endif
        qmoon


%install
install -d $RPM_BUILD_ROOT/%{_bindir}
make installdata INSTALLDIR=$RPM_BUILD_ROOT/%{_datadir}/%{name}
%if %with gtk
make -C gmoon install INSTALLPREFIX=$RPM_BUILD_ROOT/%{_prefix}
%endif
install -p -m 0755 qmoon/qmoon $RPM_BUILD_ROOT/%{_bindir}
%if %with gtk
desktop-file-install \
%if (0%{?fedora} && 0%{?fedora} < 19) || ( 0%{?rhel} && 0%{?rhel} < 7)
        --vendor="fedora"                          \
%endif
        --dir=${RPM_BUILD_ROOT}%{_datadir}/applications         \
        %{SOURCE1}
%endif
desktop-file-install \
%if (0%{?fedora} && 0%{?fedora} < 19) || ( 0%{?rhel} && 0%{?rhel} < 7)
        --vendor="fedora"                          \
%endif
        --dir=${RPM_BUILD_ROOT}%{_datadir}/applications         \
        %{SOURCE2}


%files common
%dir %{_datadir}/%{name}
%attr(0644,root,root) %{_datadir}/%{name}/*
%doc README


%if %with gtk
%files gtk
%{_bindir}/gmoon
%if (0%{?fedora} && 0%{?fedora} < 19) || ( 0%{?rhel} && 0%{?rhel} < 7)
%{_datadir}/applications/fedora-justmoon-gmoon.desktop
%else
%{_datadir}/applications/justmoon-gmoon.desktop
%endif
%endif


%files qt
%{_bindir}/qmoon
%if (0%{?fedora} && 0%{?fedora} < 19) || ( 0%{?rhel} && 0%{?rhel} < 7)
%{_datadir}/applications/fedora-justmoon-qmoon.desktop
%else
%{_datadir}/applications/justmoon-qmoon.desktop
%endif


%changelog
