Group: Networking/WWW
# BEGIN SourceDeps(oneline):
BuildRequires(pre): rpm-macros-alternatives
BuildRequires: libdb1-devel libidn-devel texinfo
# END SourceDeps(oneline)
# see https://bugzilla.altlinux.org/show_bug.cgi?id=10382
%define _localstatedir %{_var}
%{?!with_cache: %global with_cache 0}

Name: jwhois
Version: 4.0
Release: alt2_82
URL: http://www.gnu.org/software/jwhois/
Source0: ftp://ftp.gnu.org/gnu/jwhois/jwhois-%{version}.tar.gz
Source1: https://raw.githubusercontent.com/robert-scheck/jwhois/2bd561e06ca37cf6c2ef9f0a2e957e09f58e6972/example/jwhois.conf
Patch0: jwhois-4.0-connect.patch
Patch1: jwhois-4.0-ipv6match.patch
Patch2: jwhois-4.0-fclose.patch
Patch3: jwhois-4.0-select.patch
Patch5: jwhois-4.0-multi-homed.patch
Patch6: jwhois-4.0-libidn2.patch
Patch7: jwhois-4.0-idna.patch
Patch8: jwhois-4.0-idnfail.patch
# Patch9: adds options to force querying on ipv4 or ipv6, see rhbz#1551215
Patch9: jwhois-4.0-ipv4_ipv6.patch
Patch10: jwhois-configure-c99.patch
Patch11: jwhois-c99.patch
Patch12: jwhois-4.0-gcc15-fix.patch
License: GPL-3.0-only
Summary: Internet whois/nicname client
BuildRequires: gcc, libidn2-devel, autoconf, automake
%if %{with_cache}
BuildRequires: libgdbm-devel
%endif
%if 0%{?rhel} && 0%{?rhel} <= 7
%endif

%global genname whois
%global alternative jwhois
Source44: import.info

%description
A whois client that accepts both traditional and finger-style queries.

%prep
%setup -q
%patch0 -p1
%patch1 -p1
%patch2 -p1
%patch3 -p1
%patch5 -p1
%patch6 -p1
%patch7 -p1
%patch8 -p1
%patch9 -p1
%patch10 -p1
%patch11 -p1
%patch12 -p1


iconv -f iso-8859-1 -t utf-8 < doc/sv/jwhois.1 > doc/sv/jwhois.1_
mv doc/sv/jwhois.1_ doc/sv/jwhois.1

cp -pf %{SOURCE1} example/jwhois.conf

autoreconf

# Create a sysusers.d config file
cat >jwhois.sysusers.conf <<EOF
g jwhois -
EOF

%build
%if %{with_cache}
%configure --enable-sgid --localstatedir=%{_localstatedir}/cache/jwhois
%else
%configure
%endif
%make_build

%install
rm -fr $RPM_BUILD_ROOT
make install DESTDIR="$RPM_BUILD_ROOT"

%if %{with_cache}
echo 'cachefile = "/var/cache/jwhois/jwhois.db";' >> $RPM_BUILD_ROOT/etc/jwhois.conf
install -m0775 -d $RPM_BUILD_ROOT/%{_localstatedir}/cache/jwhois
touch $RPM_BUILD_ROOT/%{_localstatedir}/cache/jwhois/jwhois.db
%endif

rm -f "$RPM_BUILD_ROOT"%{_infodir}/dir
%find_lang jwhois

# Make "whois.{%%alternative}" jwhois (because of localized manual pages).
echo .so man1/jwhois.1 > $RPM_BUILD_ROOT/%{_mandir}/man1/whois.%{alternative}.1

# Rename to alternative names
touch $RPM_BUILD_ROOT%{_bindir}/whois
chmod 755 $RPM_BUILD_ROOT%{_bindir}/whois
touch $RPM_BUILD_ROOT%{_mandir}/man1/whois.1

install -m0644 -D jwhois.sysusers.conf %{buildroot}%{_sysusersdir}/jwhois.conf
for rpm404_ghost in %{_bindir}/whois %{_mandir}/man1/whois.1.gz
do
    mkdir -p %buildroot`dirname "$rpm404_ghost"`
    touch %buildroot"$rpm404_ghost"
done
install -d $RPM_BUILD_ROOT/%_altdir; cat >$RPM_BUILD_ROOT/%_altdir/%{genname}_jwhois<<EOF
%{_bindir}/whois	%{_bindir}/jwhois	60
%{_mandir}/man1/whois.1.gz	%{_mandir}/man1/whois.%{alternative}.1.gz	%{_bindir}/jwhois
EOF


%files -f %{name}.lang
%_altdir/%{genname}_jwhois
%doc AUTHORS COPYING ChangeLog NEWS README TODO
%if %{with_cache}
%attr(2711,root,jwhois) %{_bindir}/jwhois
%attr(2775,root,jwhois) %{_localstatedir}/cache/jwhois/jwhois.db
%else
%attr(0755,root,root) %{_bindir}/jwhois
%endif
%{_mandir}/man1/jwhois.1*
%lang(sv) %{_mandir}/sv/man1/jwhois.1*
%{_mandir}/man1/whois.%{alternative}.*
%{_infodir}/jwhois.info.*
%config(noreplace) %{_sysconfdir}/jwhois.conf
%{_sysusersdir}/jwhois.conf

%post
rm -f /usr/share/man/man1/whois.1.gz
:

%preun
if [ $1 = 0 ]; then
    :
fi

%changelog
