Group: Sound
# BEGIN SourceDeps(oneline):
BuildRequires(pre): rpm-macros-cmake rpm-macros-fedora-compat
BuildRequires: /usr/bin/desktop-file-validate qt5-svg-devel
# END SourceDeps(oneline)
# see https://bugzilla.altlinux.org/show_bug.cgi?id=10382
%define _localstatedir %{_var}
%define autorelease 2

%global _appid net.sourceforge.kmetronome

Name:           kmetronome
Version:        1.4.1
Release:        alt1_2
# Automatically converted from old format: GPLv2+ - review is highly recommended.
License:        GPL-2.0-or-later
Summary:        A MIDI metronome using the Drumstick library
URL:            https://kmetronome.sourceforge.net
Source:         https://downloads.sourceforge.net/%{name}/%{name}-%{version}.tar.bz2

BuildRequires:  ctest cmake
BuildRequires:  desktop-file-utils
BuildRequires:  gcc-c++
BuildRequires:  gettext-tools
BuildRequires:  libappstream-glib libappstream-glib-gir
BuildRequires:  pandoc

BuildRequires:  qt5-base-devel qt6-base-devel
BuildRequires:  qt5-base-devel qt6-base-devel
BuildRequires:  qt5-base-devel qt6-base-devel
BuildRequires:  qt6-svg-devel
BuildRequires:  qt6-svg-devel
BuildRequires:  qt5-tools qt6-tools qt6-tools-devel
BuildRequires:  drumstick-devel >= 2.10
# transitive dependency of drumstick-alsa
BuildRequires:  libalsa-devel >= 1.0
Source44: import.info

%description
KMetronome is a MIDI metronome with Qt interface, based on the Drumstick
library. The intended audience is musicians and music students. Like
solid, real metronomes it is a tool to keep the rhythm while playing musical
instruments. It uses MIDI for sound generation instead of digital audio,
allowing low CPU usage, and very accurate timing thanks to the ALSA sequencer.

%prep
%setup -q

%build
%{fedora_v2_cmake}
%fedora_v2_cmake_build

%install
%fedora_v2_cmake_install

%check
desktop-file-validate %{buildroot}%{_datadir}/applications/%{_appid}.desktop
appstream-util validate-relax --nonet %{buildroot}%{_metainfodir}/%{_appid}.metainfo.xml

%files
%doc readme.md ChangeLog AUTHORS TODO COPYING NEWS
%{_bindir}/%{name}
%{_datadir}/icons/hicolor/*/apps/%{name}.*
%{_datadir}/applications/%{_appid}.desktop
%{_datadir}/dbus-1/*/%{_appid}.*
%{_datadir}/%{name}/
%{_mandir}/man1/%{name}.1*
%{_metainfodir}/%{_appid}.metainfo.xml

%changelog
